/*
 * This declarations of the PIC16F1526 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2012.
 *
 * This file is generated automatically by the cinc2h.pl, 2012-11-01 17:30:00 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC16F1526_H__
#define __PIC16F1526_H__

//==============================================================================
//
//	Register Addresses
//
//==============================================================================

#ifndef NO_ADDR_DEFINES

#define INDF0_ADDR              0x0000
#define INDF1_ADDR              0x0001
#define PCL_ADDR                0x0002
#define STATUS_ADDR             0x0003
#define FSR0_ADDR               0x0004
#define FSR0L_ADDR              0x0004
#define FSR0H_ADDR              0x0005
#define FSR1_ADDR               0x0006
#define FSR1L_ADDR              0x0006
#define FSR1H_ADDR              0x0007
#define BSR_ADDR                0x0008
#define WREG_ADDR               0x0009
#define PCLATH_ADDR             0x000A
#define INTCON_ADDR             0x000B
#define PORTA_ADDR              0x000C
#define PORTB_ADDR              0x000D
#define PORTC_ADDR              0x000E
#define PORTD_ADDR              0x000F
#define PORTE_ADDR              0x0010
#define PIR1_ADDR               0x0011
#define PIR2_ADDR               0x0012
#define PIR3_ADDR               0x0013
#define PIR4_ADDR               0x0014
#define TMR0_ADDR               0x0015
#define TMR1_ADDR               0x0016
#define TMR1L_ADDR              0x0016
#define TMR1H_ADDR              0x0017
#define T1CON_ADDR              0x0018
#define T1GCON_ADDR             0x0019
#define TMR2_ADDR               0x001A
#define PR2_ADDR                0x001B
#define T2CON_ADDR              0x001C
#define TRISA_ADDR              0x008C
#define TRISB_ADDR              0x008D
#define TRISC_ADDR              0x008E
#define TRISD_ADDR              0x008F
#define TRISE_ADDR              0x0090
#define PIE1_ADDR               0x0091
#define PIE2_ADDR               0x0092
#define PIE3_ADDR               0x0093
#define PIE4_ADDR               0x0094
#define OPTION_REG_ADDR         0x0095
#define PCON_ADDR               0x0096
#define WDTCON_ADDR             0x0097
#define OSCCON_ADDR             0x0099
#define OSCSTAT_ADDR            0x009A
#define ADRES_ADDR              0x009B
#define ADRESL_ADDR             0x009B
#define ADRESH_ADDR             0x009C
#define ADCON0_ADDR             0x009D
#define ADCON1_ADDR             0x009E
#define LATA_ADDR               0x010C
#define LATB_ADDR               0x010D
#define LATC_ADDR               0x010E
#define LATD_ADDR               0x010F
#define LATE_ADDR               0x0110
#define BORCON_ADDR             0x0116
#define FVRCON_ADDR             0x0117
#define APFCON_ADDR             0x011D
#define ANSELA_ADDR             0x018C
#define ANSELB_ADDR             0x018D
#define ANSELD_ADDR             0x018F
#define ANSELE_ADDR             0x0190
#define PMADR_ADDR              0x0191
#define PMADRL_ADDR             0x0191
#define PMADRH_ADDR             0x0192
#define PMDAT_ADDR              0x0193
#define PMDATL_ADDR             0x0193
#define PMDATH_ADDR             0x0194
#define PMCON1_ADDR             0x0195
#define PMCON2_ADDR             0x0196
#define VREGCON_ADDR            0x0197
#define RC1REG_ADDR             0x0199
#define RCREG_ADDR              0x0199
#define RCREG1_ADDR             0x0199
#define TX1REG_ADDR             0x019A
#define TXREG_ADDR              0x019A
#define TXREG1_ADDR             0x019A
#define SP1BRGL_ADDR            0x019B
#define SPBRG_ADDR              0x019B
#define SPBRGL_ADDR             0x019B
#define SPBRGL1_ADDR            0x019B
#define SP1BRGH_ADDR            0x019C
#define SPBRGH_ADDR             0x019C
#define SPBRGH1_ADDR            0x019C
#define RC1STA_ADDR             0x019D
#define RCSTA_ADDR              0x019D
#define RCSTA1_ADDR             0x019D
#define TX1STA_ADDR             0x019E
#define TXSTA_ADDR              0x019E
#define TXSTA1_ADDR             0x019E
#define BAUD1CON_ADDR           0x019F
#define BAUDCON_ADDR            0x019F
#define BAUDCON1_ADDR           0x019F
#define WPUB_ADDR               0x020D
#define WPUD_ADDR               0x020F
#define WPUE_ADDR               0x0210
#define SSP1BUF_ADDR            0x0211
#define SSPBUF_ADDR             0x0211
#define SSP1ADD_ADDR            0x0212
#define SSPADD_ADDR             0x0212
#define SSP1MSK_ADDR            0x0213
#define SSPMSK_ADDR             0x0213
#define SSP1STAT_ADDR           0x0214
#define SSPSTAT_ADDR            0x0214
#define SSP1CON1_ADDR           0x0215
#define SSPCON_ADDR             0x0215
#define SSPCON1_ADDR            0x0215
#define SSP1CON2_ADDR           0x0216
#define SSPCON2_ADDR            0x0216
#define SSP1CON3_ADDR           0x0217
#define SSPCON3_ADDR            0x0217
#define SSP2BUF_ADDR            0x0219
#define SSP2ADD_ADDR            0x021A
#define SSP2MSK_ADDR            0x021B
#define SSP2STAT_ADDR           0x021C
#define SSP2CON1_ADDR           0x021D
#define SSP2CON2_ADDR           0x021E
#define SSP2CON3_ADDR           0x021F
#define PORTF_ADDR              0x028C
#define PORTG_ADDR              0x028D
#define CCPR1_ADDR              0x0291
#define CCPR1L_ADDR             0x0291
#define CCPR1H_ADDR             0x0292
#define CCP1CON_ADDR            0x0293
#define CCPR2_ADDR              0x0298
#define CCPR2L_ADDR             0x0298
#define CCPR2H_ADDR             0x0299
#define CCP2CON_ADDR            0x029A
#define CCPTMRS0_ADDR           0x029D
#define CCPTMRS1_ADDR           0x029E
#define CCPTMRS2_ADDR           0x029F
#define TRISF_ADDR              0x030C
#define TRISG_ADDR              0x030D
#define CCPR3_ADDR              0x0311
#define CCPR3L_ADDR             0x0311
#define CCPR3H_ADDR             0x0312
#define CCP3CON_ADDR            0x0313
#define CCPR4_ADDR              0x0318
#define CCPR4L_ADDR             0x0318
#define CCPR4H_ADDR             0x0319
#define CCP4CON_ADDR            0x031A
#define CCPR5_ADDR              0x031C
#define CCPR5L_ADDR             0x031C
#define CCPR5H_ADDR             0x031D
#define CCP5CON_ADDR            0x031E
#define LATF_ADDR               0x038C
#define LATG_ADDR               0x038D
#define IOCBP_ADDR              0x0394
#define IOCBN_ADDR              0x0395
#define IOCBF_ADDR              0x0396
#define ANSELF_ADDR             0x040C
#define ANSELG_ADDR             0x040D
#define TMR3_ADDR               0x0411
#define TMR3L_ADDR              0x0411
#define TMR3H_ADDR              0x0412
#define T3CON_ADDR              0x0413
#define T3GCON_ADDR             0x0414
#define TMR4_ADDR               0x0415
#define PR4_ADDR                0x0416
#define T4CON_ADDR              0x0417
#define TMR5_ADDR               0x0418
#define TMR5L_ADDR              0x0418
#define TMR5H_ADDR              0x0419
#define T5CON_ADDR              0x041A
#define T5GCON_ADDR             0x041B
#define TMR6_ADDR               0x041C
#define PR6_ADDR                0x041D
#define T6CON_ADDR              0x041E
#define WPUG_ADDR               0x048D
#define RC2REG_ADDR             0x0491
#define RCREG2_ADDR             0x0491
#define TX2REG_ADDR             0x0492
#define TXREG2_ADDR             0x0492
#define SP2BRG_ADDR             0x0493
#define SP2BRGL_ADDR            0x0493
#define SPBRGL2_ADDR            0x0493
#define SP2BRGH_ADDR            0x0494
#define SPBRGH2_ADDR            0x0494
#define RC2STA_ADDR             0x0495
#define RCSTA2_ADDR             0x0495
#define TX2STA_ADDR             0x0496
#define TXSTA2_ADDR             0x0496
#define BAUD2CON_ADDR           0x0497
#define BAUDCON2_ADDR           0x0497
#define TMR8_ADDR               0x0595
#define PR8_ADDR                0x0596
#define T8CON_ADDR              0x0597
#define TMR10_ADDR              0x059C
#define PR10_ADDR               0x059D
#define T10CON_ADDR             0x059E
#define CCPR6_ADDR              0x0611
#define CCPR6L_ADDR             0x0611
#define CCPR6H_ADDR             0x0612
#define CCP6CON_ADDR            0x0613
#define CCPR7_ADDR              0x0614
#define CCPR7L_ADDR             0x0614
#define CCPR7H_ADDR             0x0615
#define CCP7CON_ADDR            0x0616
#define CCPR8_ADDR              0x0617
#define CCPR8L_ADDR             0x0617
#define CCPR8H_ADDR             0x0618
#define CCP8CON_ADDR            0x0619
#define CCPR9_ADDR              0x061A
#define CCPR9L_ADDR             0x061A
#define CCPR9H_ADDR             0x061B
#define CCP9CON_ADDR            0x061C
#define CCPR10_ADDR             0x061D
#define CCPR10L_ADDR            0x061D
#define CCPR10H_ADDR            0x061E
#define CCP10CON_ADDR           0x061F
#define STATUS_SHAD_ADDR        0x0FE4
#define WREG_SHAD_ADDR          0x0FE5
#define BSR_SHAD_ADDR           0x0FE6
#define PCLATH_SHAD_ADDR        0x0FE7
#define FSR0L_SHAD_ADDR         0x0FE8
#define FSR0H_SHAD_ADDR         0x0FE9
#define FSR1L_SHAD_ADDR         0x0FEA
#define FSR1H_SHAD_ADDR         0x0FEB
#define STKPTR_ADDR             0x0FED
#define TOSL_ADDR               0x0FEE
#define TOSH_ADDR               0x0FEF

#endif // #ifndef NO_ADDR_DEFINES

//==============================================================================
//
//	Register Definitions
//
//==============================================================================

extern __at(0x0000) __sfr INDF0;
extern __at(0x0001) __sfr INDF1;
extern __at(0x0002) __sfr PCL;

//==============================================================================
//        STATUS Bits

extern __at(0x0003) __sfr STATUS;

typedef struct
  {
  unsigned C                    : 1;
  unsigned DC                   : 1;
  unsigned Z                    : 1;
  unsigned NOT_PD               : 1;
  unsigned NOT_TO               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUSbits_t;

extern __at(0x0003) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _NOT_PD                 0x08
#define _NOT_TO                 0x10

//==============================================================================

extern __at(0x0004) __sfr FSR0;
extern __at(0x0004) __sfr FSR0L;
extern __at(0x0005) __sfr FSR0H;
extern __at(0x0006) __sfr FSR1;
extern __at(0x0006) __sfr FSR1L;
extern __at(0x0007) __sfr FSR1H;

//==============================================================================
//        BSR Bits

extern __at(0x0008) __sfr BSR;

typedef union
  {
  struct
    {
    unsigned BSR0               : 1;
    unsigned BSR1               : 1;
    unsigned BSR2               : 1;
    unsigned BSR3               : 1;
    unsigned BSR4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned BSR                : 5;
    unsigned                    : 3;
    };
  } __BSRbits_t;

extern __at(0x0008) volatile __BSRbits_t BSRbits;

#define _BSR0                   0x01
#define _BSR1                   0x02
#define _BSR2                   0x04
#define _BSR3                   0x08
#define _BSR4                   0x10

//==============================================================================

extern __at(0x0009) __sfr WREG;
extern __at(0x000A) __sfr PCLATH;

//==============================================================================
//        INTCON Bits

extern __at(0x000B) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned IOCIF              : 1;
    unsigned INTF               : 1;
    unsigned TMR0IF             : 1;
    unsigned IOCIE              : 1;
    unsigned INTE               : 1;
    unsigned TMR0IE             : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __INTCONbits_t;

extern __at(0x000B) volatile __INTCONbits_t INTCONbits;

#define _IOCIF                  0x01
#define _INTF                   0x02
#define _TMR0IF                 0x04
#define _T0IF                   0x04
#define _IOCIE                  0x08
#define _INTE                   0x10
#define _TMR0IE                 0x20
#define _T0IE                   0x20
#define _PEIE                   0x40
#define _GIE                    0x80

//==============================================================================


//==============================================================================
//        PORTA Bits

extern __at(0x000C) __sfr PORTA;

typedef struct
  {
  unsigned RA0                  : 1;
  unsigned RA1                  : 1;
  unsigned RA2                  : 1;
  unsigned RA3                  : 1;
  unsigned RA4                  : 1;
  unsigned RA5                  : 1;
  unsigned RA6                  : 1;
  unsigned RA7                  : 1;
  } __PORTAbits_t;

extern __at(0x000C) volatile __PORTAbits_t PORTAbits;

#define _RA0                    0x01
#define _RA1                    0x02
#define _RA2                    0x04
#define _RA3                    0x08
#define _RA4                    0x10
#define _RA5                    0x20
#define _RA6                    0x40
#define _RA7                    0x80

//==============================================================================


//==============================================================================
//        PORTB Bits

extern __at(0x000D) __sfr PORTB;

typedef struct
  {
  unsigned RB0                  : 1;
  unsigned RB1                  : 1;
  unsigned RB2                  : 1;
  unsigned RB3                  : 1;
  unsigned RB4                  : 1;
  unsigned RB5                  : 1;
  unsigned RB6                  : 1;
  unsigned RB7                  : 1;
  } __PORTBbits_t;

extern __at(0x000D) volatile __PORTBbits_t PORTBbits;

#define _RB0                    0x01
#define _RB1                    0x02
#define _RB2                    0x04
#define _RB3                    0x08
#define _RB4                    0x10
#define _RB5                    0x20
#define _RB6                    0x40
#define _RB7                    0x80

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x000E) __sfr PORTC;

typedef struct
  {
  unsigned RC0                  : 1;
  unsigned RC1                  : 1;
  unsigned RC2                  : 1;
  unsigned RC3                  : 1;
  unsigned RC4                  : 1;
  unsigned RC5                  : 1;
  unsigned RC6                  : 1;
  unsigned RC7                  : 1;
  } __PORTCbits_t;

extern __at(0x000E) volatile __PORTCbits_t PORTCbits;

#define _RC0                    0x01
#define _RC1                    0x02
#define _RC2                    0x04
#define _RC3                    0x08
#define _RC4                    0x10
#define _RC5                    0x20
#define _RC6                    0x40
#define _RC7                    0x80

//==============================================================================


//==============================================================================
//        PORTD Bits

extern __at(0x000F) __sfr PORTD;

typedef struct
  {
  unsigned RD0                  : 1;
  unsigned RD1                  : 1;
  unsigned RD2                  : 1;
  unsigned RD3                  : 1;
  unsigned RD4                  : 1;
  unsigned RD5                  : 1;
  unsigned RD6                  : 1;
  unsigned RD7                  : 1;
  } __PORTDbits_t;

extern __at(0x000F) volatile __PORTDbits_t PORTDbits;

#define _RD0                    0x01
#define _RD1                    0x02
#define _RD2                    0x04
#define _RD3                    0x08
#define _RD4                    0x10
#define _RD5                    0x20
#define _RD6                    0x40
#define _RD7                    0x80

//==============================================================================


//==============================================================================
//        PORTE Bits

extern __at(0x0010) __sfr PORTE;

typedef struct
  {
  unsigned RE0                  : 1;
  unsigned RE1                  : 1;
  unsigned RE2                  : 1;
  unsigned RE3                  : 1;
  unsigned RE4                  : 1;
  unsigned RE5                  : 1;
  unsigned RE6                  : 1;
  unsigned RE7                  : 1;
  } __PORTEbits_t;

extern __at(0x0010) volatile __PORTEbits_t PORTEbits;

#define _RE0                    0x01
#define _RE1                    0x02
#define _RE2                    0x04
#define _RE3                    0x08
#define _RE4                    0x10
#define _RE5                    0x20
#define _RE6                    0x40
#define _RE7                    0x80

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x0011) __sfr PIR1;

typedef union
  {
  struct
    {
    unsigned TMR1IF             : 1;
    unsigned TMR2IF             : 1;
    unsigned CCP1IF             : 1;
    unsigned SSP1IF             : 1;
    unsigned TX1IF              : 1;
    unsigned RC1IF              : 1;
    unsigned ADIF               : 1;
    unsigned TMR1GIF            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SSPIF              : 1;
    unsigned TXIF               : 1;
    unsigned RCIF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIR1bits_t;

extern __at(0x0011) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _CCP1IF                 0x04
#define _SSP1IF                 0x08
#define _SSPIF                  0x08
#define _TX1IF                  0x10
#define _TXIF                   0x10
#define _RC1IF                  0x20
#define _RCIF                   0x20
#define _ADIF                   0x40
#define _TMR1GIF                0x80

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x0012) __sfr PIR2;

typedef union
  {
  struct
    {
    unsigned CCP2IF             : 1;
    unsigned TMR8IF             : 1;
    unsigned TMR10IF            : 1;
    unsigned BCL1IF             : 1;
    unsigned                    : 1;
    unsigned TMR3GIF            : 1;
    unsigned TMR5GIF            : 1;
    unsigned OSFIF              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned BCLIF              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIR2bits_t;

extern __at(0x0012) volatile __PIR2bits_t PIR2bits;

#define _CCP2IF                 0x01
#define _TMR8IF                 0x02
#define _TMR10IF                0x04
#define _BCL1IF                 0x08
#define _BCLIF                  0x08
#define _TMR3GIF                0x20
#define _TMR5GIF                0x40
#define _OSFIF                  0x80

//==============================================================================


//==============================================================================
//        PIR3 Bits

extern __at(0x0013) __sfr PIR3;

typedef struct
  {
  unsigned TMR3IF               : 1;
  unsigned TMR4IF               : 1;
  unsigned TMR5IF               : 1;
  unsigned TMR6IF               : 1;
  unsigned CCP3IF               : 1;
  unsigned CCP4IF               : 1;
  unsigned CCP5IF               : 1;
  unsigned CCP6IF               : 1;
  } __PIR3bits_t;

extern __at(0x0013) volatile __PIR3bits_t PIR3bits;

#define _TMR3IF                 0x01
#define _TMR4IF                 0x02
#define _TMR5IF                 0x04
#define _TMR6IF                 0x08
#define _CCP3IF                 0x10
#define _CCP4IF                 0x20
#define _CCP5IF                 0x40
#define _CCP6IF                 0x80

//==============================================================================


//==============================================================================
//        PIR4 Bits

extern __at(0x0014) __sfr PIR4;

typedef struct
  {
  unsigned SSP2IF               : 1;
  unsigned BCL2IF               : 1;
  unsigned CCP7IF               : 1;
  unsigned CCP8IF               : 1;
  unsigned TX2IF                : 1;
  unsigned RC2IF                : 1;
  unsigned CCP9IF               : 1;
  unsigned CCP10IF              : 1;
  } __PIR4bits_t;

extern __at(0x0014) volatile __PIR4bits_t PIR4bits;

#define _SSP2IF                 0x01
#define _BCL2IF                 0x02
#define _CCP7IF                 0x04
#define _CCP8IF                 0x08
#define _TX2IF                  0x10
#define _RC2IF                  0x20
#define _CCP9IF                 0x40
#define _CCP10IF                0x80

//==============================================================================

extern __at(0x0015) __sfr TMR0;
extern __at(0x0016) __sfr TMR1;
extern __at(0x0016) __sfr TMR1L;
extern __at(0x0017) __sfr TMR1H;

//==============================================================================
//        T1CON Bits

extern __at(0x0018) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned                    : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned SOSCEN             : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned TMR1CS0            : 1;
    unsigned TMR1CS1            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1OSCEN            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR1CS             : 2;
    };
  } __T1CONbits_t;

extern __at(0x0018) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _NOT_T1SYNC             0x04
#define _SOSCEN                 0x08
#define _T1OSCEN                0x08
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20
#define _TMR1CS0                0x40
#define _TMR1CS1                0x80

//==============================================================================


//==============================================================================
//        T1GCON Bits

extern __at(0x0019) __sfr T1GCON;

typedef union
  {
  struct
    {
    unsigned T1GSS0             : 1;
    unsigned T1GSS1             : 1;
    unsigned T1GVAL             : 1;
    unsigned T1GGO_NOT_DONE     : 1;
    unsigned T1GSPM             : 1;
    unsigned T1GTM              : 1;
    unsigned T1GPOL             : 1;
    unsigned TMR1GE             : 1;
    };

  struct
    {
    unsigned T1GSS              : 2;
    unsigned                    : 6;
    };
  } __T1GCONbits_t;

extern __at(0x0019) volatile __T1GCONbits_t T1GCONbits;

#define _T1GSS0                 0x01
#define _T1GSS1                 0x02
#define _T1GVAL                 0x04
#define _T1GGO_NOT_DONE         0x08
#define _T1GSPM                 0x10
#define _T1GTM                  0x20
#define _T1GPOL                 0x40
#define _TMR1GE                 0x80

//==============================================================================

extern __at(0x001A) __sfr TMR2;
extern __at(0x001B) __sfr PR2;

//==============================================================================
//        T2CON Bits

extern __at(0x001C) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned TMR2ON             : 1;
    unsigned T2OUTPS0           : 1;
    unsigned T2OUTPS1           : 1;
    unsigned T2OUTPS2           : 1;
    unsigned T2OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T2OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x001C) volatile __T2CONbits_t T2CONbits;

#define _T2CKPS0                0x01
#define _T2CKPS1                0x02
#define _TMR2ON                 0x04
#define _T2OUTPS0               0x08
#define _T2OUTPS1               0x10
#define _T2OUTPS2               0x20
#define _T2OUTPS3               0x40

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x008C) __sfr TRISA;

typedef struct
  {
  unsigned TRISA0               : 1;
  unsigned TRISA1               : 1;
  unsigned TRISA2               : 1;
  unsigned TRISA3               : 1;
  unsigned TRISA4               : 1;
  unsigned TRISA5               : 1;
  unsigned TRISA6               : 1;
  unsigned TRISA7               : 1;
  } __TRISAbits_t;

extern __at(0x008C) volatile __TRISAbits_t TRISAbits;

#define _TRISA0                 0x01
#define _TRISA1                 0x02
#define _TRISA2                 0x04
#define _TRISA3                 0x08
#define _TRISA4                 0x10
#define _TRISA5                 0x20
#define _TRISA6                 0x40
#define _TRISA7                 0x80

//==============================================================================


//==============================================================================
//        TRISB Bits

extern __at(0x008D) __sfr TRISB;

typedef struct
  {
  unsigned TRISB0               : 1;
  unsigned TRISB1               : 1;
  unsigned TRISB2               : 1;
  unsigned TRISB3               : 1;
  unsigned TRISB4               : 1;
  unsigned TRISB5               : 1;
  unsigned TRISB6               : 1;
  unsigned TRISB7               : 1;
  } __TRISBbits_t;

extern __at(0x008D) volatile __TRISBbits_t TRISBbits;

#define _TRISB0                 0x01
#define _TRISB1                 0x02
#define _TRISB2                 0x04
#define _TRISB3                 0x08
#define _TRISB4                 0x10
#define _TRISB5                 0x20
#define _TRISB6                 0x40
#define _TRISB7                 0x80

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x008E) __sfr TRISC;

typedef struct
  {
  unsigned TRISC0               : 1;
  unsigned TRISC1               : 1;
  unsigned TRISC2               : 1;
  unsigned TRISC3               : 1;
  unsigned TRISC4               : 1;
  unsigned TRISC5               : 1;
  unsigned TRISC6               : 1;
  unsigned TRISC7               : 1;
  } __TRISCbits_t;

extern __at(0x008E) volatile __TRISCbits_t TRISCbits;

#define _TRISC0                 0x01
#define _TRISC1                 0x02
#define _TRISC2                 0x04
#define _TRISC3                 0x08
#define _TRISC4                 0x10
#define _TRISC5                 0x20
#define _TRISC6                 0x40
#define _TRISC7                 0x80

//==============================================================================


//==============================================================================
//        TRISD Bits

extern __at(0x008F) __sfr TRISD;

typedef struct
  {
  unsigned TRISD0               : 1;
  unsigned TRISD1               : 1;
  unsigned TRISD2               : 1;
  unsigned TRISD3               : 1;
  unsigned TRISD4               : 1;
  unsigned TRISD5               : 1;
  unsigned TRISD6               : 1;
  unsigned TRISD7               : 1;
  } __TRISDbits_t;

extern __at(0x008F) volatile __TRISDbits_t TRISDbits;

#define _TRISD0                 0x01
#define _TRISD1                 0x02
#define _TRISD2                 0x04
#define _TRISD3                 0x08
#define _TRISD4                 0x10
#define _TRISD5                 0x20
#define _TRISD6                 0x40
#define _TRISD7                 0x80

//==============================================================================


//==============================================================================
//        TRISE Bits

extern __at(0x0090) __sfr TRISE;

typedef struct
  {
  unsigned TRISE0               : 1;
  unsigned TRISE1               : 1;
  unsigned TRISE2               : 1;
  unsigned TRISE3               : 1;
  unsigned TRISE4               : 1;
  unsigned TRISE5               : 1;
  unsigned TRISE6               : 1;
  unsigned TRISE7               : 1;
  } __TRISEbits_t;

extern __at(0x0090) volatile __TRISEbits_t TRISEbits;

#define _TRISE0                 0x01
#define _TRISE1                 0x02
#define _TRISE2                 0x04
#define _TRISE3                 0x08
#define _TRISE4                 0x10
#define _TRISE5                 0x20
#define _TRISE6                 0x40
#define _TRISE7                 0x80

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x0091) __sfr PIE1;

typedef union
  {
  struct
    {
    unsigned TMR1IE             : 1;
    unsigned TMR2IE             : 1;
    unsigned CCP1IE             : 1;
    unsigned SSP1IE             : 1;
    unsigned TX1IE              : 1;
    unsigned RC1IE              : 1;
    unsigned ADIE               : 1;
    unsigned TMR1GIE            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SSPIE              : 1;
    unsigned TXIE               : 1;
    unsigned RCIE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIE1bits_t;

extern __at(0x0091) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _CCP1IE                 0x04
#define _SSP1IE                 0x08
#define _SSPIE                  0x08
#define _TX1IE                  0x10
#define _TXIE                   0x10
#define _RC1IE                  0x20
#define _RCIE                   0x20
#define _ADIE                   0x40
#define _TMR1GIE                0x80

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x0092) __sfr PIE2;

typedef union
  {
  struct
    {
    unsigned CCP2IE             : 1;
    unsigned TMR8IE             : 1;
    unsigned TMR10IE            : 1;
    unsigned BCL1IE             : 1;
    unsigned                    : 1;
    unsigned TMR3GIE            : 1;
    unsigned TMR5GIE            : 1;
    unsigned OSFIE              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned BCLIE              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIE2bits_t;

extern __at(0x0092) volatile __PIE2bits_t PIE2bits;

#define _CCP2IE                 0x01
#define _TMR8IE                 0x02
#define _TMR10IE                0x04
#define _BCL1IE                 0x08
#define _BCLIE                  0x08
#define _TMR3GIE                0x20
#define _TMR5GIE                0x40
#define _OSFIE                  0x80

//==============================================================================


//==============================================================================
//        PIE3 Bits

extern __at(0x0093) __sfr PIE3;

typedef struct
  {
  unsigned TMR3IE               : 1;
  unsigned TMR4IE               : 1;
  unsigned TMR5IE               : 1;
  unsigned TMR6IE               : 1;
  unsigned CCP3IE               : 1;
  unsigned CCP4IE               : 1;
  unsigned CCP5IE               : 1;
  unsigned CCP6IE               : 1;
  } __PIE3bits_t;

extern __at(0x0093) volatile __PIE3bits_t PIE3bits;

#define _TMR3IE                 0x01
#define _TMR4IE                 0x02
#define _TMR5IE                 0x04
#define _TMR6IE                 0x08
#define _CCP3IE                 0x10
#define _CCP4IE                 0x20
#define _CCP5IE                 0x40
#define _CCP6IE                 0x80

//==============================================================================


//==============================================================================
//        PIE4 Bits

extern __at(0x0094) __sfr PIE4;

typedef struct
  {
  unsigned SSP2IE               : 1;
  unsigned BCL2IE               : 1;
  unsigned CCP7IE               : 1;
  unsigned CCP8IE               : 1;
  unsigned TX2IE                : 1;
  unsigned RC2IE                : 1;
  unsigned CCP9IE               : 1;
  unsigned CCP10IE              : 1;
  } __PIE4bits_t;

extern __at(0x0094) volatile __PIE4bits_t PIE4bits;

#define _SSP2IE                 0x01
#define _BCL2IE                 0x02
#define _CCP7IE                 0x04
#define _CCP8IE                 0x08
#define _TX2IE                  0x10
#define _RC2IE                  0x20
#define _CCP9IE                 0x40
#define _CCP10IE                0x80

//==============================================================================


//==============================================================================
//        OPTION_REG Bits

extern __at(0x0095) __sfr OPTION_REG;

typedef union
  {
  struct
    {
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PS2                : 1;
    unsigned PSA                : 1;
    unsigned TMR0SE             : 1;
    unsigned TMR0CS             : 1;
    unsigned INTEDG             : 1;
    unsigned NOT_WPUEN          : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PS                 : 3;
    unsigned                    : 5;
    };
  } __OPTION_REGbits_t;

extern __at(0x0095) volatile __OPTION_REGbits_t OPTION_REGbits;

#define _PS0                    0x01
#define _PS1                    0x02
#define _PS2                    0x04
#define _PSA                    0x08
#define _TMR0SE                 0x10
#define _T0SE                   0x10
#define _TMR0CS                 0x20
#define _T0CS                   0x20
#define _INTEDG                 0x40
#define _NOT_WPUEN              0x80

//==============================================================================


//==============================================================================
//        PCON Bits

extern __at(0x0096) __sfr PCON;

typedef struct
  {
  unsigned NOT_BOR              : 1;
  unsigned NOT_POR              : 1;
  unsigned NOT_RI               : 1;
  unsigned NOT_RMCLR            : 1;
  unsigned NOT_RWDT             : 1;
  unsigned                      : 1;
  unsigned STKUNF               : 1;
  unsigned STKOVF               : 1;
  } __PCONbits_t;

extern __at(0x0096) volatile __PCONbits_t PCONbits;

#define _NOT_BOR                0x01
#define _NOT_POR                0x02
#define _NOT_RI                 0x04
#define _NOT_RMCLR              0x08
#define _NOT_RWDT               0x10
#define _STKUNF                 0x40
#define _STKOVF                 0x80

//==============================================================================


//==============================================================================
//        WDTCON Bits

extern __at(0x0097) __sfr WDTCON;

typedef union
  {
  struct
    {
    unsigned SWDTEN             : 1;
    unsigned WDTPS0             : 1;
    unsigned WDTPS1             : 1;
    unsigned WDTPS2             : 1;
    unsigned WDTPS3             : 1;
    unsigned WDTPS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WDTPS              : 5;
    unsigned                    : 2;
    };
  } __WDTCONbits_t;

extern __at(0x0097) volatile __WDTCONbits_t WDTCONbits;

#define _SWDTEN                 0x01
#define _WDTPS0                 0x02
#define _WDTPS1                 0x04
#define _WDTPS2                 0x08
#define _WDTPS3                 0x10
#define _WDTPS4                 0x20

//==============================================================================


//==============================================================================
//        OSCCON Bits

extern __at(0x0099) __sfr OSCCON;

typedef union
  {
  struct
    {
    unsigned SCS0               : 1;
    unsigned SCS1               : 1;
    unsigned                    : 1;
    unsigned IRCF0              : 1;
    unsigned IRCF1              : 1;
    unsigned IRCF2              : 1;
    unsigned IRCF3              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SCS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned IRCF               : 4;
    unsigned                    : 1;
    };
  } __OSCCONbits_t;

extern __at(0x0099) volatile __OSCCONbits_t OSCCONbits;

#define _SCS0                   0x01
#define _SCS1                   0x02
#define _IRCF0                  0x08
#define _IRCF1                  0x10
#define _IRCF2                  0x20
#define _IRCF3                  0x40

//==============================================================================


//==============================================================================
//        OSCSTAT Bits

extern __at(0x009A) __sfr OSCSTAT;

typedef union
  {
  struct
    {
    unsigned HFIOFS             : 1;
    unsigned LFIOFR             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned HFIOFR             : 1;
    unsigned OSTS               : 1;
    unsigned                    : 1;
    unsigned SOSCR              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1OSCR             : 1;
    };
  } __OSCSTATbits_t;

extern __at(0x009A) volatile __OSCSTATbits_t OSCSTATbits;

#define _HFIOFS                 0x01
#define _LFIOFR                 0x02
#define _HFIOFR                 0x10
#define _OSTS                   0x20
#define _SOSCR                  0x80
#define _T1OSCR                 0x80

//==============================================================================

extern __at(0x009B) __sfr ADRES;
extern __at(0x009B) __sfr ADRESL;
extern __at(0x009C) __sfr ADRESH;

//==============================================================================
//        ADCON0 Bits

extern __at(0x009D) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned CHS4               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ADGO               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 5;
    unsigned                    : 1;
    };
  } __ADCON0bits_t;

extern __at(0x009D) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _GO_NOT_DONE            0x02
#define _ADGO                   0x02
#define _GO                     0x02
#define _CHS0                   0x04
#define _CHS1                   0x08
#define _CHS2                   0x10
#define _CHS3                   0x20
#define _CHS4                   0x40

//==============================================================================


//==============================================================================
//        ADCON1 Bits

extern __at(0x009E) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned ADPREF0            : 1;
    unsigned ADPREF1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    unsigned ADCS2              : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned ADPREF             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ADCS               : 3;
    unsigned                    : 1;
    };
  } __ADCON1bits_t;

extern __at(0x009E) volatile __ADCON1bits_t ADCON1bits;

#define _ADPREF0                0x01
#define _ADPREF1                0x02
#define _ADCS0                  0x10
#define _ADCS1                  0x20
#define _ADCS2                  0x40
#define _ADFM                   0x80

//==============================================================================


//==============================================================================
//        LATA Bits

extern __at(0x010C) __sfr LATA;

typedef struct
  {
  unsigned LATA0                : 1;
  unsigned LATA1                : 1;
  unsigned LATA2                : 1;
  unsigned LATA3                : 1;
  unsigned LATA4                : 1;
  unsigned LATA5                : 1;
  unsigned LATA6                : 1;
  unsigned LATA7                : 1;
  } __LATAbits_t;

extern __at(0x010C) volatile __LATAbits_t LATAbits;

#define _LATA0                  0x01
#define _LATA1                  0x02
#define _LATA2                  0x04
#define _LATA3                  0x08
#define _LATA4                  0x10
#define _LATA5                  0x20
#define _LATA6                  0x40
#define _LATA7                  0x80

//==============================================================================


//==============================================================================
//        LATB Bits

extern __at(0x010D) __sfr LATB;

typedef struct
  {
  unsigned LATB0                : 1;
  unsigned LATB1                : 1;
  unsigned LATB2                : 1;
  unsigned LATB3                : 1;
  unsigned LATB4                : 1;
  unsigned LATB5                : 1;
  unsigned LATB6                : 1;
  unsigned LATB7                : 1;
  } __LATBbits_t;

extern __at(0x010D) volatile __LATBbits_t LATBbits;

#define _LATB0                  0x01
#define _LATB1                  0x02
#define _LATB2                  0x04
#define _LATB3                  0x08
#define _LATB4                  0x10
#define _LATB5                  0x20
#define _LATB6                  0x40
#define _LATB7                  0x80

//==============================================================================


//==============================================================================
//        LATC Bits

extern __at(0x010E) __sfr LATC;

typedef struct
  {
  unsigned LATC0                : 1;
  unsigned LATC1                : 1;
  unsigned LATC2                : 1;
  unsigned LATC3                : 1;
  unsigned LATC4                : 1;
  unsigned LATC5                : 1;
  unsigned LATC6                : 1;
  unsigned LATC7                : 1;
  } __LATCbits_t;

extern __at(0x010E) volatile __LATCbits_t LATCbits;

#define _LATC0                  0x01
#define _LATC1                  0x02
#define _LATC2                  0x04
#define _LATC3                  0x08
#define _LATC4                  0x10
#define _LATC5                  0x20
#define _LATC6                  0x40
#define _LATC7                  0x80

//==============================================================================


//==============================================================================
//        LATD Bits

extern __at(0x010F) __sfr LATD;

typedef struct
  {
  unsigned LATD0                : 1;
  unsigned LATD1                : 1;
  unsigned LATD2                : 1;
  unsigned LATD3                : 1;
  unsigned LATD4                : 1;
  unsigned LATD5                : 1;
  unsigned LATD6                : 1;
  unsigned LATD7                : 1;
  } __LATDbits_t;

extern __at(0x010F) volatile __LATDbits_t LATDbits;

#define _LATD0                  0x01
#define _LATD1                  0x02
#define _LATD2                  0x04
#define _LATD3                  0x08
#define _LATD4                  0x10
#define _LATD5                  0x20
#define _LATD6                  0x40
#define _LATD7                  0x80

//==============================================================================


//==============================================================================
//        LATE Bits

extern __at(0x0110) __sfr LATE;

typedef struct
  {
  unsigned LATE0                : 1;
  unsigned LATE1                : 1;
  unsigned LATE2                : 1;
  unsigned LATE3                : 1;
  unsigned LATE4                : 1;
  unsigned LATE5                : 1;
  unsigned LATE6                : 1;
  unsigned LATE7                : 1;
  } __LATEbits_t;

extern __at(0x0110) volatile __LATEbits_t LATEbits;

#define _LATE0                  0x01
#define _LATE1                  0x02
#define _LATE2                  0x04
#define _LATE3                  0x08
#define _LATE4                  0x10
#define _LATE5                  0x20
#define _LATE6                  0x40
#define _LATE7                  0x80

//==============================================================================


//==============================================================================
//        BORCON Bits

extern __at(0x0116) __sfr BORCON;

typedef struct
  {
  unsigned BORRDY               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned BORFS                : 1;
  unsigned SBOREN               : 1;
  } __BORCONbits_t;

extern __at(0x0116) volatile __BORCONbits_t BORCONbits;

#define _BORRDY                 0x01
#define _BORFS                  0x40
#define _SBOREN                 0x80

//==============================================================================


//==============================================================================
//        FVRCON Bits

extern __at(0x0117) __sfr FVRCON;

typedef union
  {
  struct
    {
    unsigned ADFVR0             : 1;
    unsigned ADFVR1             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TSRNG              : 1;
    unsigned TSEN               : 1;
    unsigned FVRRDY             : 1;
    unsigned FVREN              : 1;
    };

  struct
    {
    unsigned ADFVR              : 2;
    unsigned                    : 6;
    };
  } __FVRCONbits_t;

extern __at(0x0117) volatile __FVRCONbits_t FVRCONbits;

#define _ADFVR0                 0x01
#define _ADFVR1                 0x02
#define _TSRNG                  0x10
#define _TSEN                   0x20
#define _FVRRDY                 0x40
#define _FVREN                  0x80

//==============================================================================


//==============================================================================
//        APFCON Bits

extern __at(0x011D) __sfr APFCON;

typedef struct
  {
  unsigned CCP2SEL              : 1;
  unsigned T3CKISEL             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __APFCONbits_t;

extern __at(0x011D) volatile __APFCONbits_t APFCONbits;

#define _CCP2SEL                0x01
#define _T3CKISEL               0x02

//==============================================================================


//==============================================================================
//        ANSELA Bits

extern __at(0x018C) __sfr ANSELA;

typedef struct
  {
  unsigned ANSA0                : 1;
  unsigned ANSA1                : 1;
  unsigned ANSA2                : 1;
  unsigned ANSA3                : 1;
  unsigned                      : 1;
  unsigned ANSA5                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ANSELAbits_t;

extern __at(0x018C) volatile __ANSELAbits_t ANSELAbits;

#define _ANSA0                  0x01
#define _ANSA1                  0x02
#define _ANSA2                  0x04
#define _ANSA3                  0x08
#define _ANSA5                  0x20

//==============================================================================


//==============================================================================
//        ANSELB Bits

extern __at(0x018D) __sfr ANSELB;

typedef union
  {
  struct
    {
    unsigned ANSB0              : 1;
    unsigned ANSB1              : 1;
    unsigned ANSB2              : 1;
    unsigned ANSB3              : 1;
    unsigned ANSB4              : 1;
    unsigned ANSB5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ANSB               : 6;
    unsigned                    : 2;
    };
  } __ANSELBbits_t;

extern __at(0x018D) volatile __ANSELBbits_t ANSELBbits;

#define _ANSB0                  0x01
#define _ANSB1                  0x02
#define _ANSB2                  0x04
#define _ANSB3                  0x08
#define _ANSB4                  0x10
#define _ANSB5                  0x20

//==============================================================================


//==============================================================================
//        ANSELD Bits

extern __at(0x018F) __sfr ANSELD;

typedef union
  {
  struct
    {
    unsigned ANSD0              : 1;
    unsigned ANSD1              : 1;
    unsigned ANSD2              : 1;
    unsigned ANSD3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ANSD               : 4;
    unsigned                    : 4;
    };
  } __ANSELDbits_t;

extern __at(0x018F) volatile __ANSELDbits_t ANSELDbits;

#define _ANSD0                  0x01
#define _ANSD1                  0x02
#define _ANSD2                  0x04
#define _ANSD3                  0x08

//==============================================================================


//==============================================================================
//        ANSELE Bits

extern __at(0x0190) __sfr ANSELE;

typedef union
  {
  struct
    {
    unsigned ANSE0              : 1;
    unsigned ANSE1              : 1;
    unsigned ANSE2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ANSE               : 3;
    unsigned                    : 5;
    };
  } __ANSELEbits_t;

extern __at(0x0190) volatile __ANSELEbits_t ANSELEbits;

#define _ANSE0                  0x01
#define _ANSE1                  0x02
#define _ANSE2                  0x04

//==============================================================================

extern __at(0x0191) __sfr PMADR;
extern __at(0x0191) __sfr PMADRL;
extern __at(0x0192) __sfr PMADRH;
extern __at(0x0193) __sfr PMDAT;
extern __at(0x0193) __sfr PMDATL;
extern __at(0x0194) __sfr PMDATH;

//==============================================================================
//        PMCON1 Bits

extern __at(0x0195) __sfr PMCON1;

typedef struct
  {
  unsigned RD                   : 1;
  unsigned WR                   : 1;
  unsigned WREN                 : 1;
  unsigned WRERR                : 1;
  unsigned FREE                 : 1;
  unsigned LWLO                 : 1;
  unsigned CFGS                 : 1;
  unsigned                      : 1;
  } __PMCON1bits_t;

extern __at(0x0195) volatile __PMCON1bits_t PMCON1bits;

#define _RD                     0x01
#define _WR                     0x02
#define _WREN                   0x04
#define _WRERR                  0x08
#define _FREE                   0x10
#define _LWLO                   0x20
#define _CFGS                   0x40

//==============================================================================

extern __at(0x0196) __sfr PMCON2;

//==============================================================================
//        VREGCON Bits

extern __at(0x0197) __sfr VREGCON;

typedef struct
  {
  unsigned                      : 1;
  unsigned VREGPM               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __VREGCONbits_t;

extern __at(0x0197) volatile __VREGCONbits_t VREGCONbits;

#define _VREGPM                 0x02

//==============================================================================

extern __at(0x0199) __sfr RC1REG;
extern __at(0x0199) __sfr RCREG;
extern __at(0x0199) __sfr RCREG1;
extern __at(0x019A) __sfr TX1REG;
extern __at(0x019A) __sfr TXREG;
extern __at(0x019A) __sfr TXREG1;
extern __at(0x019B) __sfr SP1BRGL;
extern __at(0x019B) __sfr SPBRG;
extern __at(0x019B) __sfr SPBRGL;
extern __at(0x019B) __sfr SPBRGL1;
extern __at(0x019C) __sfr SP1BRGH;
extern __at(0x019C) __sfr SPBRGH;
extern __at(0x019C) __sfr SPBRGH1;

//==============================================================================
//        RC1STA Bits

extern __at(0x019D) __sfr RC1STA;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RC1STAbits_t;

extern __at(0x019D) volatile __RC1STAbits_t RC1STAbits;

#define _RX9D                   0x01
#define _OERR                   0x02
#define _FERR                   0x04
#define _ADDEN                  0x08
#define _CREN                   0x10
#define _SREN                   0x20
#define _RX9                    0x40
#define _SPEN                   0x80

//==============================================================================


//==============================================================================
//        RCSTA Bits

extern __at(0x019D) __sfr RCSTA;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RCSTAbits_t;

extern __at(0x019D) volatile __RCSTAbits_t RCSTAbits;

#define _RCSTA_RX9D             0x01
#define _RCSTA_OERR             0x02
#define _RCSTA_FERR             0x04
#define _RCSTA_ADDEN            0x08
#define _RCSTA_CREN             0x10
#define _RCSTA_SREN             0x20
#define _RCSTA_RX9              0x40
#define _RCSTA_SPEN             0x80

//==============================================================================


//==============================================================================
//        RCSTA1 Bits

extern __at(0x019D) __sfr RCSTA1;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RCSTA1bits_t;

extern __at(0x019D) volatile __RCSTA1bits_t RCSTA1bits;

#define _RCSTA1_RX9D            0x01
#define _RCSTA1_OERR            0x02
#define _RCSTA1_FERR            0x04
#define _RCSTA1_ADDEN           0x08
#define _RCSTA1_CREN            0x10
#define _RCSTA1_SREN            0x20
#define _RCSTA1_RX9             0x40
#define _RCSTA1_SPEN            0x80

//==============================================================================


//==============================================================================
//        TX1STA Bits

extern __at(0x019E) __sfr TX1STA;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TX1STAbits_t;

extern __at(0x019E) volatile __TX1STAbits_t TX1STAbits;

#define _TX9D                   0x01
#define _TRMT                   0x02
#define _BRGH                   0x04
#define _SENDB                  0x08
#define _SYNC                   0x10
#define _TXEN                   0x20
#define _TX9                    0x40
#define _CSRC                   0x80

//==============================================================================


//==============================================================================
//        TXSTA Bits

extern __at(0x019E) __sfr TXSTA;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TXSTAbits_t;

extern __at(0x019E) volatile __TXSTAbits_t TXSTAbits;

#define _TXSTA_TX9D             0x01
#define _TXSTA_TRMT             0x02
#define _TXSTA_BRGH             0x04
#define _TXSTA_SENDB            0x08
#define _TXSTA_SYNC             0x10
#define _TXSTA_TXEN             0x20
#define _TXSTA_TX9              0x40
#define _TXSTA_CSRC             0x80

//==============================================================================


//==============================================================================
//        TXSTA1 Bits

extern __at(0x019E) __sfr TXSTA1;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TXSTA1bits_t;

extern __at(0x019E) volatile __TXSTA1bits_t TXSTA1bits;

#define _TXSTA1_TX9D            0x01
#define _TXSTA1_TRMT            0x02
#define _TXSTA1_BRGH            0x04
#define _TXSTA1_SENDB           0x08
#define _TXSTA1_SYNC            0x10
#define _TXSTA1_TXEN            0x20
#define _TXSTA1_TX9             0x40
#define _TXSTA1_CSRC            0x80

//==============================================================================


//==============================================================================
//        BAUD1CON Bits

extern __at(0x019F) __sfr BAUD1CON;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUD1CONbits_t;

extern __at(0x019F) volatile __BAUD1CONbits_t BAUD1CONbits;

#define _ABDEN                  0x01
#define _WUE                    0x02
#define _BRG16                  0x08
#define _SCKP                   0x10
#define _RCIDL                  0x40
#define _ABDOVF                 0x80

//==============================================================================


//==============================================================================
//        BAUDCON Bits

extern __at(0x019F) __sfr BAUDCON;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCONbits_t;

extern __at(0x019F) volatile __BAUDCONbits_t BAUDCONbits;

#define _BAUDCON_ABDEN          0x01
#define _BAUDCON_WUE            0x02
#define _BAUDCON_BRG16          0x08
#define _BAUDCON_SCKP           0x10
#define _BAUDCON_RCIDL          0x40
#define _BAUDCON_ABDOVF         0x80

//==============================================================================


//==============================================================================
//        BAUDCON1 Bits

extern __at(0x019F) __sfr BAUDCON1;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCON1bits_t;

extern __at(0x019F) volatile __BAUDCON1bits_t BAUDCON1bits;

#define _BAUDCON1_ABDEN         0x01
#define _BAUDCON1_WUE           0x02
#define _BAUDCON1_BRG16         0x08
#define _BAUDCON1_SCKP          0x10
#define _BAUDCON1_RCIDL         0x40
#define _BAUDCON1_ABDOVF        0x80

//==============================================================================


//==============================================================================
//        WPUB Bits

extern __at(0x020D) __sfr WPUB;

typedef struct
  {
  unsigned WPUB0                : 1;
  unsigned WPUB1                : 1;
  unsigned WPUB2                : 1;
  unsigned WPUB3                : 1;
  unsigned WPUB4                : 1;
  unsigned WPUB5                : 1;
  unsigned WPUB6                : 1;
  unsigned WPUB7                : 1;
  } __WPUBbits_t;

extern __at(0x020D) volatile __WPUBbits_t WPUBbits;

#define _WPUB0                  0x01
#define _WPUB1                  0x02
#define _WPUB2                  0x04
#define _WPUB3                  0x08
#define _WPUB4                  0x10
#define _WPUB5                  0x20
#define _WPUB6                  0x40
#define _WPUB7                  0x80

//==============================================================================


//==============================================================================
//        WPUD Bits

extern __at(0x020F) __sfr WPUD;

typedef struct
  {
  unsigned WPUD0                : 1;
  unsigned WPUD1                : 1;
  unsigned WPUD2                : 1;
  unsigned WPUD3                : 1;
  unsigned WPUD4                : 1;
  unsigned WPUD5                : 1;
  unsigned WPUD6                : 1;
  unsigned WPUD7                : 1;
  } __WPUDbits_t;

extern __at(0x020F) volatile __WPUDbits_t WPUDbits;

#define _WPUD0                  0x01
#define _WPUD1                  0x02
#define _WPUD2                  0x04
#define _WPUD3                  0x08
#define _WPUD4                  0x10
#define _WPUD5                  0x20
#define _WPUD6                  0x40
#define _WPUD7                  0x80

//==============================================================================


//==============================================================================
//        WPUE Bits

extern __at(0x0210) __sfr WPUE;

typedef struct
  {
  unsigned WPUE0                : 1;
  unsigned WPUE1                : 1;
  unsigned WPUE2                : 1;
  unsigned WPUE3                : 1;
  unsigned WPUE4                : 1;
  unsigned WPUE5                : 1;
  unsigned WPUE6                : 1;
  unsigned WPUE7                : 1;
  } __WPUEbits_t;

extern __at(0x0210) volatile __WPUEbits_t WPUEbits;

#define _WPUE0                  0x01
#define _WPUE1                  0x02
#define _WPUE2                  0x04
#define _WPUE3                  0x08
#define _WPUE4                  0x10
#define _WPUE5                  0x20
#define _WPUE6                  0x40
#define _WPUE7                  0x80

//==============================================================================

extern __at(0x0211) __sfr SSP1BUF;
extern __at(0x0211) __sfr SSPBUF;
extern __at(0x0212) __sfr SSP1ADD;
extern __at(0x0212) __sfr SSPADD;
extern __at(0x0213) __sfr SSP1MSK;
extern __at(0x0213) __sfr SSPMSK;

//==============================================================================
//        SSP1STAT Bits

extern __at(0x0214) __sfr SSP1STAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSP1STATbits_t;

extern __at(0x0214) volatile __SSP1STATbits_t SSP1STATbits;

#define _BF                     0x01
#define _UA                     0x02
#define _R_NOT_W                0x04
#define _S                      0x08
#define _P                      0x10
#define _D_NOT_A                0x20
#define _CKE                    0x40
#define _SMP                    0x80

//==============================================================================


//==============================================================================
//        SSPSTAT Bits

extern __at(0x0214) __sfr SSPSTAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSPSTATbits_t;

extern __at(0x0214) volatile __SSPSTATbits_t SSPSTATbits;

#define _SSPSTAT_BF             0x01
#define _SSPSTAT_UA             0x02
#define _SSPSTAT_R_NOT_W        0x04
#define _SSPSTAT_S              0x08
#define _SSPSTAT_P              0x10
#define _SSPSTAT_D_NOT_A        0x20
#define _SSPSTAT_CKE            0x40
#define _SSPSTAT_SMP            0x80

//==============================================================================


//==============================================================================
//        SSP1CON1 Bits

extern __at(0x0215) __sfr SSP1CON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP1CON1bits_t;

extern __at(0x0215) volatile __SSP1CON1bits_t SSP1CON1bits;

#define _SSPM0                  0x01
#define _SSPM1                  0x02
#define _SSPM2                  0x04
#define _SSPM3                  0x08
#define _CKP                    0x10
#define _SSPEN                  0x20
#define _SSPOV                  0x40
#define _WCOL                   0x80

//==============================================================================


//==============================================================================
//        SSPCON Bits

extern __at(0x0215) __sfr SSPCON;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCONbits_t;

extern __at(0x0215) volatile __SSPCONbits_t SSPCONbits;

#define _SSPCON_SSPM0           0x01
#define _SSPCON_SSPM1           0x02
#define _SSPCON_SSPM2           0x04
#define _SSPCON_SSPM3           0x08
#define _SSPCON_CKP             0x10
#define _SSPCON_SSPEN           0x20
#define _SSPCON_SSPOV           0x40
#define _SSPCON_WCOL            0x80

//==============================================================================


//==============================================================================
//        SSPCON1 Bits

extern __at(0x0215) __sfr SSPCON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCON1bits_t;

extern __at(0x0215) volatile __SSPCON1bits_t SSPCON1bits;

#define _SSPCON1_SSPM0          0x01
#define _SSPCON1_SSPM1          0x02
#define _SSPCON1_SSPM2          0x04
#define _SSPCON1_SSPM3          0x08
#define _SSPCON1_CKP            0x10
#define _SSPCON1_SSPEN          0x20
#define _SSPCON1_SSPOV          0x40
#define _SSPCON1_WCOL           0x80

//==============================================================================


//==============================================================================
//        SSP1CON2 Bits

extern __at(0x0216) __sfr SSP1CON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSP1CON2bits_t;

extern __at(0x0216) volatile __SSP1CON2bits_t SSP1CON2bits;

#define _SEN                    0x01
#define _RSEN                   0x02
#define _PEN                    0x04
#define _RCEN                   0x08
#define _ACKEN                  0x10
#define _ACKDT                  0x20
#define _ACKSTAT                0x40
#define _GCEN                   0x80

//==============================================================================


//==============================================================================
//        SSPCON2 Bits

extern __at(0x0216) __sfr SSPCON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSPCON2bits_t;

extern __at(0x0216) volatile __SSPCON2bits_t SSPCON2bits;

#define _SSPCON2_SEN            0x01
#define _SSPCON2_RSEN           0x02
#define _SSPCON2_PEN            0x04
#define _SSPCON2_RCEN           0x08
#define _SSPCON2_ACKEN          0x10
#define _SSPCON2_ACKDT          0x20
#define _SSPCON2_ACKSTAT        0x40
#define _SSPCON2_GCEN           0x80

//==============================================================================


//==============================================================================
//        SSP1CON3 Bits

extern __at(0x0217) __sfr SSP1CON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSP1CON3bits_t;

extern __at(0x0217) volatile __SSP1CON3bits_t SSP1CON3bits;

#define _DHEN                   0x01
#define _AHEN                   0x02
#define _SBCDE                  0x04
#define _SDAHT                  0x08
#define _BOEN                   0x10
#define _SCIE                   0x20
#define _PCIE                   0x40
#define _ACKTIM                 0x80

//==============================================================================


//==============================================================================
//        SSPCON3 Bits

extern __at(0x0217) __sfr SSPCON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSPCON3bits_t;

extern __at(0x0217) volatile __SSPCON3bits_t SSPCON3bits;

#define _SSPCON3_DHEN           0x01
#define _SSPCON3_AHEN           0x02
#define _SSPCON3_SBCDE          0x04
#define _SSPCON3_SDAHT          0x08
#define _SSPCON3_BOEN           0x10
#define _SSPCON3_SCIE           0x20
#define _SSPCON3_PCIE           0x40
#define _SSPCON3_ACKTIM         0x80

//==============================================================================

extern __at(0x0219) __sfr SSP2BUF;
extern __at(0x021A) __sfr SSP2ADD;
extern __at(0x021B) __sfr SSP2MSK;

//==============================================================================
//        SSP2STAT Bits

extern __at(0x021C) __sfr SSP2STAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSP2STATbits_t;

extern __at(0x021C) volatile __SSP2STATbits_t SSP2STATbits;

#define _SSP2STAT_BF            0x01
#define _SSP2STAT_UA            0x02
#define _SSP2STAT_R_NOT_W       0x04
#define _SSP2STAT_S             0x08
#define _SSP2STAT_P             0x10
#define _SSP2STAT_D_NOT_A       0x20
#define _SSP2STAT_CKE           0x40
#define _SSP2STAT_SMP           0x80

//==============================================================================


//==============================================================================
//        SSP2CON1 Bits

extern __at(0x021D) __sfr SSP2CON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP2CON1bits_t;

extern __at(0x021D) volatile __SSP2CON1bits_t SSP2CON1bits;

#define _SSP2CON1_SSPM0         0x01
#define _SSP2CON1_SSPM1         0x02
#define _SSP2CON1_SSPM2         0x04
#define _SSP2CON1_SSPM3         0x08
#define _SSP2CON1_CKP           0x10
#define _SSP2CON1_SSPEN         0x20
#define _SSP2CON1_SSPOV         0x40
#define _SSP2CON1_WCOL          0x80

//==============================================================================


//==============================================================================
//        SSP2CON2 Bits

extern __at(0x021E) __sfr SSP2CON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSP2CON2bits_t;

extern __at(0x021E) volatile __SSP2CON2bits_t SSP2CON2bits;

#define _SSP2CON2_SEN           0x01
#define _SSP2CON2_RSEN          0x02
#define _SSP2CON2_PEN           0x04
#define _SSP2CON2_RCEN          0x08
#define _SSP2CON2_ACKEN         0x10
#define _SSP2CON2_ACKDT         0x20
#define _SSP2CON2_ACKSTAT       0x40
#define _SSP2CON2_GCEN          0x80

//==============================================================================


//==============================================================================
//        SSP2CON3 Bits

extern __at(0x021F) __sfr SSP2CON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSP2CON3bits_t;

extern __at(0x021F) volatile __SSP2CON3bits_t SSP2CON3bits;

#define _SSP2CON3_DHEN          0x01
#define _SSP2CON3_AHEN          0x02
#define _SSP2CON3_SBCDE         0x04
#define _SSP2CON3_SDAHT         0x08
#define _SSP2CON3_BOEN          0x10
#define _SSP2CON3_SCIE          0x20
#define _SSP2CON3_PCIE          0x40
#define _SSP2CON3_ACKTIM        0x80

//==============================================================================


//==============================================================================
//        PORTF Bits

extern __at(0x028C) __sfr PORTF;

typedef struct
  {
  unsigned RF0                  : 1;
  unsigned RF1                  : 1;
  unsigned RF2                  : 1;
  unsigned RF3                  : 1;
  unsigned RF4                  : 1;
  unsigned RF5                  : 1;
  unsigned RF6                  : 1;
  unsigned RF7                  : 1;
  } __PORTFbits_t;

extern __at(0x028C) volatile __PORTFbits_t PORTFbits;

#define _RF0                    0x01
#define _RF1                    0x02
#define _RF2                    0x04
#define _RF3                    0x08
#define _RF4                    0x10
#define _RF5                    0x20
#define _RF6                    0x40
#define _RF7                    0x80

//==============================================================================


//==============================================================================
//        PORTG Bits

extern __at(0x028D) __sfr PORTG;

typedef union
  {
  struct
    {
    unsigned RG0                : 1;
    unsigned RG1                : 1;
    unsigned RG2                : 1;
    unsigned RG3                : 1;
    unsigned RG4                : 1;
    unsigned RG5                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG                 : 6;
    unsigned                    : 2;
    };
  } __PORTGbits_t;

extern __at(0x028D) volatile __PORTGbits_t PORTGbits;

#define _RG0                    0x01
#define _RG1                    0x02
#define _RG2                    0x04
#define _RG3                    0x08
#define _RG4                    0x10
#define _RG5                    0x20

//==============================================================================

extern __at(0x0291) __sfr CCPR1;
extern __at(0x0291) __sfr CCPR1L;
extern __at(0x0292) __sfr CCPR1H;

//==============================================================================
//        CCP1CON Bits

extern __at(0x0293) __sfr CCP1CON;

typedef union
  {
  struct
    {
    unsigned CCP1M0             : 1;
    unsigned CCP1M1             : 1;
    unsigned CCP1M2             : 1;
    unsigned CCP1M3             : 1;
    unsigned DC1B0              : 1;
    unsigned DC1B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC1B               : 2;
    unsigned                    : 2;
    };
  } __CCP1CONbits_t;

extern __at(0x0293) volatile __CCP1CONbits_t CCP1CONbits;

#define _CCP1M0                 0x01
#define _CCP1M1                 0x02
#define _CCP1M2                 0x04
#define _CCP1M3                 0x08
#define _DC1B0                  0x10
#define _DC1B1                  0x20

//==============================================================================

extern __at(0x0298) __sfr CCPR2;
extern __at(0x0298) __sfr CCPR2L;
extern __at(0x0299) __sfr CCPR2H;

//==============================================================================
//        CCP2CON Bits

extern __at(0x029A) __sfr CCP2CON;

typedef union
  {
  struct
    {
    unsigned CCP2M0             : 1;
    unsigned CCP2M1             : 1;
    unsigned CCP2M2             : 1;
    unsigned CCP2M3             : 1;
    unsigned DC2B0              : 1;
    unsigned DC2B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP2M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC2B               : 2;
    unsigned                    : 2;
    };
  } __CCP2CONbits_t;

extern __at(0x029A) volatile __CCP2CONbits_t CCP2CONbits;

#define _CCP2M0                 0x01
#define _CCP2M1                 0x02
#define _CCP2M2                 0x04
#define _CCP2M3                 0x08
#define _DC2B0                  0x10
#define _DC2B1                  0x20

//==============================================================================


//==============================================================================
//        CCPTMRS0 Bits

extern __at(0x029D) __sfr CCPTMRS0;

typedef union
  {
  struct
    {
    unsigned C1TSEL0            : 1;
    unsigned C1TSEL1            : 1;
    unsigned C2TSEL0            : 1;
    unsigned C2TSEL1            : 1;
    unsigned C3TSEL0            : 1;
    unsigned C3TSEL1            : 1;
    unsigned C4TSEL0            : 1;
    unsigned C4TSEL1            : 1;
    };

  struct
    {
    unsigned C1TSEL             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned C2TSEL             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned C3TSEL             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned C4TSEL             : 2;
    };
  } __CCPTMRS0bits_t;

extern __at(0x029D) volatile __CCPTMRS0bits_t CCPTMRS0bits;

#define _C1TSEL0                0x01
#define _C1TSEL1                0x02
#define _C2TSEL0                0x04
#define _C2TSEL1                0x08
#define _C3TSEL0                0x10
#define _C3TSEL1                0x20
#define _C4TSEL0                0x40
#define _C4TSEL1                0x80

//==============================================================================


//==============================================================================
//        CCPTMRS1 Bits

extern __at(0x029E) __sfr CCPTMRS1;

typedef union
  {
  struct
    {
    unsigned C5TSEL0            : 1;
    unsigned C5TSEL1            : 1;
    unsigned C6TSEL0            : 1;
    unsigned C6TSEL1            : 1;
    unsigned C7TSEL0            : 1;
    unsigned C7TSEL1            : 1;
    unsigned C8TSEL0            : 1;
    unsigned C8TSEL1            : 1;
    };

  struct
    {
    unsigned C5TSEL             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned C6TSEL             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned C7TSEL             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned C8TSEL             : 2;
    };
  } __CCPTMRS1bits_t;

extern __at(0x029E) volatile __CCPTMRS1bits_t CCPTMRS1bits;

#define _C5TSEL0                0x01
#define _C5TSEL1                0x02
#define _C6TSEL0                0x04
#define _C6TSEL1                0x08
#define _C7TSEL0                0x10
#define _C7TSEL1                0x20
#define _C8TSEL0                0x40
#define _C8TSEL1                0x80

//==============================================================================


//==============================================================================
//        CCPTMRS2 Bits

extern __at(0x029F) __sfr CCPTMRS2;

typedef union
  {
  struct
    {
    unsigned C9TSEL0            : 1;
    unsigned C9TSEL1            : 1;
    unsigned C10TSEL0           : 1;
    unsigned C10TSEL1           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C9TSEL             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned C10TSEL            : 2;
    unsigned                    : 4;
    };
  } __CCPTMRS2bits_t;

extern __at(0x029F) volatile __CCPTMRS2bits_t CCPTMRS2bits;

#define _C9TSEL0                0x01
#define _C9TSEL1                0x02
#define _C10TSEL0               0x04
#define _C10TSEL1               0x08

//==============================================================================


//==============================================================================
//        TRISF Bits

extern __at(0x030C) __sfr TRISF;

typedef struct
  {
  unsigned TRISF0               : 1;
  unsigned TRISF1               : 1;
  unsigned TRISF2               : 1;
  unsigned TRISF3               : 1;
  unsigned TRISF4               : 1;
  unsigned TRISF5               : 1;
  unsigned TRISF6               : 1;
  unsigned TRISF7               : 1;
  } __TRISFbits_t;

extern __at(0x030C) volatile __TRISFbits_t TRISFbits;

#define _TRISF0                 0x01
#define _TRISF1                 0x02
#define _TRISF2                 0x04
#define _TRISF3                 0x08
#define _TRISF4                 0x10
#define _TRISF5                 0x20
#define _TRISF6                 0x40
#define _TRISF7                 0x80

//==============================================================================


//==============================================================================
//        TRISG Bits

extern __at(0x030D) __sfr TRISG;

typedef union
  {
  struct
    {
    unsigned TRISG0             : 1;
    unsigned TRISG1             : 1;
    unsigned TRISG2             : 1;
    unsigned TRISG3             : 1;
    unsigned TRISG4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISG              : 5;
    unsigned                    : 3;
    };
  } __TRISGbits_t;

extern __at(0x030D) volatile __TRISGbits_t TRISGbits;

#define _TRISG0                 0x01
#define _TRISG1                 0x02
#define _TRISG2                 0x04
#define _TRISG3                 0x08
#define _TRISG4                 0x10

//==============================================================================

extern __at(0x0311) __sfr CCPR3;
extern __at(0x0311) __sfr CCPR3L;
extern __at(0x0312) __sfr CCPR3H;

//==============================================================================
//        CCP3CON Bits

extern __at(0x0313) __sfr CCP3CON;

typedef union
  {
  struct
    {
    unsigned CCP3M0             : 1;
    unsigned CCP3M1             : 1;
    unsigned CCP3M2             : 1;
    unsigned CCP3M3             : 1;
    unsigned DC3B0              : 1;
    unsigned DC3B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP3M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC3B               : 2;
    unsigned                    : 2;
    };
  } __CCP3CONbits_t;

extern __at(0x0313) volatile __CCP3CONbits_t CCP3CONbits;

#define _CCP3M0                 0x01
#define _CCP3M1                 0x02
#define _CCP3M2                 0x04
#define _CCP3M3                 0x08
#define _DC3B0                  0x10
#define _DC3B1                  0x20

//==============================================================================

extern __at(0x0318) __sfr CCPR4;
extern __at(0x0318) __sfr CCPR4L;
extern __at(0x0319) __sfr CCPR4H;

//==============================================================================
//        CCP4CON Bits

extern __at(0x031A) __sfr CCP4CON;

typedef union
  {
  struct
    {
    unsigned CCP4M0             : 1;
    unsigned CCP4M1             : 1;
    unsigned CCP4M2             : 1;
    unsigned CCP4M3             : 1;
    unsigned DC4B0              : 1;
    unsigned DC4B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP4M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC4B               : 2;
    unsigned                    : 2;
    };
  } __CCP4CONbits_t;

extern __at(0x031A) volatile __CCP4CONbits_t CCP4CONbits;

#define _CCP4M0                 0x01
#define _CCP4M1                 0x02
#define _CCP4M2                 0x04
#define _CCP4M3                 0x08
#define _DC4B0                  0x10
#define _DC4B1                  0x20

//==============================================================================

extern __at(0x031C) __sfr CCPR5;
extern __at(0x031C) __sfr CCPR5L;
extern __at(0x031D) __sfr CCPR5H;

//==============================================================================
//        CCP5CON Bits

extern __at(0x031E) __sfr CCP5CON;

typedef union
  {
  struct
    {
    unsigned CCP5M0             : 1;
    unsigned CCP5M1             : 1;
    unsigned CCP5M2             : 1;
    unsigned CCP5M3             : 1;
    unsigned DC5B0              : 1;
    unsigned DC5B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP5M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC5B               : 2;
    unsigned                    : 2;
    };
  } __CCP5CONbits_t;

extern __at(0x031E) volatile __CCP5CONbits_t CCP5CONbits;

#define _CCP5M0                 0x01
#define _CCP5M1                 0x02
#define _CCP5M2                 0x04
#define _CCP5M3                 0x08
#define _DC5B0                  0x10
#define _DC5B1                  0x20

//==============================================================================


//==============================================================================
//        LATF Bits

extern __at(0x038C) __sfr LATF;

typedef struct
  {
  unsigned LATF0                : 1;
  unsigned LATF1                : 1;
  unsigned LATF2                : 1;
  unsigned LATF3                : 1;
  unsigned LATF4                : 1;
  unsigned LATF5                : 1;
  unsigned LATF6                : 1;
  unsigned LATF7                : 1;
  } __LATFbits_t;

extern __at(0x038C) volatile __LATFbits_t LATFbits;

#define _LATF0                  0x01
#define _LATF1                  0x02
#define _LATF2                  0x04
#define _LATF3                  0x08
#define _LATF4                  0x10
#define _LATF5                  0x20
#define _LATF6                  0x40
#define _LATF7                  0x80

//==============================================================================


//==============================================================================
//        LATG Bits

extern __at(0x038D) __sfr LATG;

typedef union
  {
  struct
    {
    unsigned LATG0              : 1;
    unsigned LATG1              : 1;
    unsigned LATG2              : 1;
    unsigned LATG3              : 1;
    unsigned LATG4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LATG               : 5;
    unsigned                    : 3;
    };
  } __LATGbits_t;

extern __at(0x038D) volatile __LATGbits_t LATGbits;

#define _LATG0                  0x01
#define _LATG1                  0x02
#define _LATG2                  0x04
#define _LATG3                  0x08
#define _LATG4                  0x10

//==============================================================================


//==============================================================================
//        IOCBP Bits

extern __at(0x0394) __sfr IOCBP;

typedef struct
  {
  unsigned IOCBP0               : 1;
  unsigned IOCBP1               : 1;
  unsigned IOCBP2               : 1;
  unsigned IOCBP3               : 1;
  unsigned IOCBP4               : 1;
  unsigned IOCBP5               : 1;
  unsigned IOCBP6               : 1;
  unsigned IOCBP7               : 1;
  } __IOCBPbits_t;

extern __at(0x0394) volatile __IOCBPbits_t IOCBPbits;

#define _IOCBP0                 0x01
#define _IOCBP1                 0x02
#define _IOCBP2                 0x04
#define _IOCBP3                 0x08
#define _IOCBP4                 0x10
#define _IOCBP5                 0x20
#define _IOCBP6                 0x40
#define _IOCBP7                 0x80

//==============================================================================


//==============================================================================
//        IOCBN Bits

extern __at(0x0395) __sfr IOCBN;

typedef struct
  {
  unsigned IOCBN0               : 1;
  unsigned IOCBN1               : 1;
  unsigned IOCBN2               : 1;
  unsigned IOCBN3               : 1;
  unsigned IOCBN4               : 1;
  unsigned IOCBN5               : 1;
  unsigned IOCBN6               : 1;
  unsigned IOCBN7               : 1;
  } __IOCBNbits_t;

extern __at(0x0395) volatile __IOCBNbits_t IOCBNbits;

#define _IOCBN0                 0x01
#define _IOCBN1                 0x02
#define _IOCBN2                 0x04
#define _IOCBN3                 0x08
#define _IOCBN4                 0x10
#define _IOCBN5                 0x20
#define _IOCBN6                 0x40
#define _IOCBN7                 0x80

//==============================================================================


//==============================================================================
//        IOCBF Bits

extern __at(0x0396) __sfr IOCBF;

typedef struct
  {
  unsigned IOCBF0               : 1;
  unsigned IOCBF1               : 1;
  unsigned IOCBF2               : 1;
  unsigned IOCBF3               : 1;
  unsigned IOCBF4               : 1;
  unsigned IOCBF5               : 1;
  unsigned IOCBF6               : 1;
  unsigned IOCBF7               : 1;
  } __IOCBFbits_t;

extern __at(0x0396) volatile __IOCBFbits_t IOCBFbits;

#define _IOCBF0                 0x01
#define _IOCBF1                 0x02
#define _IOCBF2                 0x04
#define _IOCBF3                 0x08
#define _IOCBF4                 0x10
#define _IOCBF5                 0x20
#define _IOCBF6                 0x40
#define _IOCBF7                 0x80

//==============================================================================


//==============================================================================
//        ANSELF Bits

extern __at(0x040C) __sfr ANSELF;

typedef struct
  {
  unsigned ANSF0                : 1;
  unsigned ANSF1                : 1;
  unsigned ANSF2                : 1;
  unsigned ANSF3                : 1;
  unsigned ANSF4                : 1;
  unsigned ANSF5                : 1;
  unsigned ANSF6                : 1;
  unsigned ANSF7                : 1;
  } __ANSELFbits_t;

extern __at(0x040C) volatile __ANSELFbits_t ANSELFbits;

#define _ANSF0                  0x01
#define _ANSF1                  0x02
#define _ANSF2                  0x04
#define _ANSF3                  0x08
#define _ANSF4                  0x10
#define _ANSF5                  0x20
#define _ANSF6                  0x40
#define _ANSF7                  0x80

//==============================================================================


//==============================================================================
//        ANSELG Bits

extern __at(0x040D) __sfr ANSELG;

typedef struct
  {
  unsigned                      : 1;
  unsigned ANSG1                : 1;
  unsigned ANSG2                : 1;
  unsigned ANSG3                : 1;
  unsigned ANSG4                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ANSELGbits_t;

extern __at(0x040D) volatile __ANSELGbits_t ANSELGbits;

#define _ANSG1                  0x02
#define _ANSG2                  0x04
#define _ANSG3                  0x08
#define _ANSG4                  0x10

//==============================================================================

extern __at(0x0411) __sfr TMR3;
extern __at(0x0411) __sfr TMR3L;
extern __at(0x0412) __sfr TMR3H;

//==============================================================================
//        T3CON Bits

extern __at(0x0413) __sfr T3CON;

typedef union
  {
  struct
    {
    unsigned TMR3ON             : 1;
    unsigned                    : 1;
    unsigned NOT_T3SYNC         : 1;
    unsigned SOSCEN             : 1;
    unsigned T3CKPS0            : 1;
    unsigned T3CKPS1            : 1;
    unsigned TMR3CS0            : 1;
    unsigned TMR3CS1            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T3OSCEN            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T3CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR3CS             : 2;
    };
  } __T3CONbits_t;

extern __at(0x0413) volatile __T3CONbits_t T3CONbits;

#define _T3CON_TMR3ON           0x01
#define _T3CON_NOT_T3SYNC       0x04
#define _T3CON_SOSCEN           0x08
#define _T3CON_T3OSCEN          0x08
#define _T3CON_T3CKPS0          0x10
#define _T3CON_T3CKPS1          0x20
#define _T3CON_TMR3CS0          0x40
#define _T3CON_TMR3CS1          0x80

//==============================================================================


//==============================================================================
//        T3GCON Bits

extern __at(0x0414) __sfr T3GCON;

typedef union
  {
  struct
    {
    unsigned T3GSS0             : 1;
    unsigned T3GSS1             : 1;
    unsigned T3GVAL             : 1;
    unsigned T3GGO_NOT_DONE     : 1;
    unsigned T3GSPM             : 1;
    unsigned T3GTM              : 1;
    unsigned T3GPOL             : 1;
    unsigned TMR3GE             : 1;
    };

  struct
    {
    unsigned T3GSS              : 2;
    unsigned                    : 6;
    };
  } __T3GCONbits_t;

extern __at(0x0414) volatile __T3GCONbits_t T3GCONbits;

#define _T3GSS0                 0x01
#define _T3GSS1                 0x02
#define _T3GVAL                 0x04
#define _T3GGO_NOT_DONE         0x08
#define _T3GSPM                 0x10
#define _T3GTM                  0x20
#define _T3GPOL                 0x40
#define _TMR3GE                 0x80

//==============================================================================

extern __at(0x0415) __sfr TMR4;
extern __at(0x0416) __sfr PR4;

//==============================================================================
//        T4CON Bits

extern __at(0x0417) __sfr T4CON;

typedef union
  {
  struct
    {
    unsigned T4CKPS0            : 1;
    unsigned T4CKPS1            : 1;
    unsigned TMR4ON             : 1;
    unsigned T4OUTPS0           : 1;
    unsigned T4OUTPS1           : 1;
    unsigned T4OUTPS2           : 1;
    unsigned T4OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T4CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T4OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T4CONbits_t;

extern __at(0x0417) volatile __T4CONbits_t T4CONbits;

#define _T4CKPS0                0x01
#define _T4CKPS1                0x02
#define _TMR4ON                 0x04
#define _T4OUTPS0               0x08
#define _T4OUTPS1               0x10
#define _T4OUTPS2               0x20
#define _T4OUTPS3               0x40

//==============================================================================

extern __at(0x0418) __sfr TMR5;
extern __at(0x0418) __sfr TMR5L;
extern __at(0x0419) __sfr TMR5H;

//==============================================================================
//        T5CON Bits

extern __at(0x041A) __sfr T5CON;

typedef union
  {
  struct
    {
    unsigned TMR5ON             : 1;
    unsigned                    : 1;
    unsigned NOT_T5SYNC         : 1;
    unsigned SOSCEN             : 1;
    unsigned T5CKPS0            : 1;
    unsigned T5CKPS1            : 1;
    unsigned TMR5CS0            : 1;
    unsigned TMR5CS1            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T5OSCEN            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T5CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR5CS             : 2;
    };
  } __T5CONbits_t;

extern __at(0x041A) volatile __T5CONbits_t T5CONbits;

#define _T5CON_TMR5ON           0x01
#define _T5CON_NOT_T5SYNC       0x04
#define _T5CON_SOSCEN           0x08
#define _T5CON_T5OSCEN          0x08
#define _T5CON_T5CKPS0          0x10
#define _T5CON_T5CKPS1          0x20
#define _T5CON_TMR5CS0          0x40
#define _T5CON_TMR5CS1          0x80

//==============================================================================


//==============================================================================
//        T5GCON Bits

extern __at(0x041B) __sfr T5GCON;

typedef union
  {
  struct
    {
    unsigned T5GSS0             : 1;
    unsigned T5GSS1             : 1;
    unsigned T5GVAL             : 1;
    unsigned T5GGO_NOT_DONE     : 1;
    unsigned T5GSPM             : 1;
    unsigned T5GTM              : 1;
    unsigned T5GPOL             : 1;
    unsigned TMR5GE             : 1;
    };

  struct
    {
    unsigned T5GSS              : 2;
    unsigned                    : 6;
    };
  } __T5GCONbits_t;

extern __at(0x041B) volatile __T5GCONbits_t T5GCONbits;

#define _T5GSS0                 0x01
#define _T5GSS1                 0x02
#define _T5GVAL                 0x04
#define _T5GGO_NOT_DONE         0x08
#define _T5GSPM                 0x10
#define _T5GTM                  0x20
#define _T5GPOL                 0x40
#define _TMR5GE                 0x80

//==============================================================================

extern __at(0x041C) __sfr TMR6;
extern __at(0x041D) __sfr PR6;

//==============================================================================
//        T6CON Bits

extern __at(0x041E) __sfr T6CON;

typedef union
  {
  struct
    {
    unsigned T6CKPS0            : 1;
    unsigned T6CKPS1            : 1;
    unsigned TMR6ON             : 1;
    unsigned T6OUTPS0           : 1;
    unsigned T6OUTPS1           : 1;
    unsigned T6OUTPS2           : 1;
    unsigned T6OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T6CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T6OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T6CONbits_t;

extern __at(0x041E) volatile __T6CONbits_t T6CONbits;

#define _T6CKPS0                0x01
#define _T6CKPS1                0x02
#define _TMR6ON                 0x04
#define _T6OUTPS0               0x08
#define _T6OUTPS1               0x10
#define _T6OUTPS2               0x20
#define _T6OUTPS3               0x40

//==============================================================================


//==============================================================================
//        WPUG Bits

extern __at(0x048D) __sfr WPUG;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned WPUG5                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __WPUGbits_t;

extern __at(0x048D) volatile __WPUGbits_t WPUGbits;

#define _WPUG5                  0x20

//==============================================================================

extern __at(0x0491) __sfr RC2REG;
extern __at(0x0491) __sfr RCREG2;
extern __at(0x0492) __sfr TX2REG;
extern __at(0x0492) __sfr TXREG2;
extern __at(0x0493) __sfr SP2BRG;
extern __at(0x0493) __sfr SP2BRGL;
extern __at(0x0493) __sfr SPBRGL2;
extern __at(0x0494) __sfr SP2BRGH;
extern __at(0x0494) __sfr SPBRGH2;

//==============================================================================
//        RC2STA Bits

extern __at(0x0495) __sfr RC2STA;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RC2STAbits_t;

extern __at(0x0495) volatile __RC2STAbits_t RC2STAbits;

#define _RC2STA_RX9D            0x01
#define _RC2STA_OERR            0x02
#define _RC2STA_FERR            0x04
#define _RC2STA_ADDEN           0x08
#define _RC2STA_CREN            0x10
#define _RC2STA_SREN            0x20
#define _RC2STA_RX9             0x40
#define _RC2STA_SPEN            0x80

//==============================================================================


//==============================================================================
//        RCSTA2 Bits

extern __at(0x0495) __sfr RCSTA2;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RCSTA2bits_t;

extern __at(0x0495) volatile __RCSTA2bits_t RCSTA2bits;

#define _RCSTA2_RX9D            0x01
#define _RCSTA2_OERR            0x02
#define _RCSTA2_FERR            0x04
#define _RCSTA2_ADDEN           0x08
#define _RCSTA2_CREN            0x10
#define _RCSTA2_SREN            0x20
#define _RCSTA2_RX9             0x40
#define _RCSTA2_SPEN            0x80

//==============================================================================


//==============================================================================
//        TX2STA Bits

extern __at(0x0496) __sfr TX2STA;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TX2STAbits_t;

extern __at(0x0496) volatile __TX2STAbits_t TX2STAbits;

#define _TX2STA_TX9D            0x01
#define _TX2STA_TRMT            0x02
#define _TX2STA_BRGH            0x04
#define _TX2STA_SENDB           0x08
#define _TX2STA_SYNC            0x10
#define _TX2STA_TXEN            0x20
#define _TX2STA_TX9             0x40
#define _TX2STA_CSRC            0x80

//==============================================================================


//==============================================================================
//        TXSTA2 Bits

extern __at(0x0496) __sfr TXSTA2;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TXSTA2bits_t;

extern __at(0x0496) volatile __TXSTA2bits_t TXSTA2bits;

#define _TXSTA2_TX9D            0x01
#define _TXSTA2_TRMT            0x02
#define _TXSTA2_BRGH            0x04
#define _TXSTA2_SENDB           0x08
#define _TXSTA2_SYNC            0x10
#define _TXSTA2_TXEN            0x20
#define _TXSTA2_TX9             0x40
#define _TXSTA2_CSRC            0x80

//==============================================================================


//==============================================================================
//        BAUD2CON Bits

extern __at(0x0497) __sfr BAUD2CON;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUD2CONbits_t;

extern __at(0x0497) volatile __BAUD2CONbits_t BAUD2CONbits;

#define _BAUD2CON_ABDEN         0x01
#define _BAUD2CON_WUE           0x02
#define _BAUD2CON_BRG16         0x08
#define _BAUD2CON_SCKP          0x10
#define _BAUD2CON_RCIDL         0x40
#define _BAUD2CON_ABDOVF        0x80

//==============================================================================


//==============================================================================
//        BAUDCON2 Bits

extern __at(0x0497) __sfr BAUDCON2;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCON2bits_t;

extern __at(0x0497) volatile __BAUDCON2bits_t BAUDCON2bits;

#define _BAUDCON2_ABDEN         0x01
#define _BAUDCON2_WUE           0x02
#define _BAUDCON2_BRG16         0x08
#define _BAUDCON2_SCKP          0x10
#define _BAUDCON2_RCIDL         0x40
#define _BAUDCON2_ABDOVF        0x80

//==============================================================================

extern __at(0x0595) __sfr TMR8;
extern __at(0x0596) __sfr PR8;

//==============================================================================
//        T8CON Bits

extern __at(0x0597) __sfr T8CON;

typedef union
  {
  struct
    {
    unsigned T8CKPS0            : 1;
    unsigned T8CKPS1            : 1;
    unsigned TMR8ON             : 1;
    unsigned T8OUTPS0           : 1;
    unsigned T8OUTPS1           : 1;
    unsigned T8OUTPS2           : 1;
    unsigned T8OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T8CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T8OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T8CONbits_t;

extern __at(0x0597) volatile __T8CONbits_t T8CONbits;

#define _T8CKPS0                0x01
#define _T8CKPS1                0x02
#define _TMR8ON                 0x04
#define _T8OUTPS0               0x08
#define _T8OUTPS1               0x10
#define _T8OUTPS2               0x20
#define _T8OUTPS3               0x40

//==============================================================================

extern __at(0x059C) __sfr TMR10;
extern __at(0x059D) __sfr PR10;

//==============================================================================
//        T10CON Bits

extern __at(0x059E) __sfr T10CON;

typedef union
  {
  struct
    {
    unsigned T10CKPS0           : 1;
    unsigned T10CKPS1           : 1;
    unsigned TMR10ON            : 1;
    unsigned T10OUTPS0          : 1;
    unsigned T10OUTPS1          : 1;
    unsigned T10OUTPS2          : 1;
    unsigned T10OUTPS3          : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T10CKPS            : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T10OUTPS           : 4;
    unsigned                    : 1;
    };
  } __T10CONbits_t;

extern __at(0x059E) volatile __T10CONbits_t T10CONbits;

#define _T10CKPS0               0x01
#define _T10CKPS1               0x02
#define _TMR10ON                0x04
#define _T10OUTPS0              0x08
#define _T10OUTPS1              0x10
#define _T10OUTPS2              0x20
#define _T10OUTPS3              0x40

//==============================================================================

extern __at(0x0611) __sfr CCPR6;
extern __at(0x0611) __sfr CCPR6L;
extern __at(0x0612) __sfr CCPR6H;

//==============================================================================
//        CCP6CON Bits

extern __at(0x0613) __sfr CCP6CON;

typedef union
  {
  struct
    {
    unsigned CCP6M0             : 1;
    unsigned CCP6M1             : 1;
    unsigned CCP6M2             : 1;
    unsigned CCP6M3             : 1;
    unsigned DC6B0              : 1;
    unsigned DC6B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP6M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC6B               : 2;
    unsigned                    : 2;
    };
  } __CCP6CONbits_t;

extern __at(0x0613) volatile __CCP6CONbits_t CCP6CONbits;

#define _CCP6M0                 0x01
#define _CCP6M1                 0x02
#define _CCP6M2                 0x04
#define _CCP6M3                 0x08
#define _DC6B0                  0x10
#define _DC6B1                  0x20

//==============================================================================

extern __at(0x0614) __sfr CCPR7;
extern __at(0x0614) __sfr CCPR7L;
extern __at(0x0615) __sfr CCPR7H;

//==============================================================================
//        CCP7CON Bits

extern __at(0x0616) __sfr CCP7CON;

typedef union
  {
  struct
    {
    unsigned CCP7M0             : 1;
    unsigned CCP7M1             : 1;
    unsigned CCP7M2             : 1;
    unsigned CCP7M3             : 1;
    unsigned DC7B0              : 1;
    unsigned DC7B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP7M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC7B               : 2;
    unsigned                    : 2;
    };
  } __CCP7CONbits_t;

extern __at(0x0616) volatile __CCP7CONbits_t CCP7CONbits;

#define _CCP7M0                 0x01
#define _CCP7M1                 0x02
#define _CCP7M2                 0x04
#define _CCP7M3                 0x08
#define _DC7B0                  0x10
#define _DC7B1                  0x20

//==============================================================================

extern __at(0x0617) __sfr CCPR8;
extern __at(0x0617) __sfr CCPR8L;
extern __at(0x0618) __sfr CCPR8H;

//==============================================================================
//        CCP8CON Bits

extern __at(0x0619) __sfr CCP8CON;

typedef union
  {
  struct
    {
    unsigned CCP8M0             : 1;
    unsigned CCP8M1             : 1;
    unsigned CCP8M2             : 1;
    unsigned CCP8M3             : 1;
    unsigned DC8B0              : 1;
    unsigned DC8B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP8M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC8B               : 2;
    unsigned                    : 2;
    };
  } __CCP8CONbits_t;

extern __at(0x0619) volatile __CCP8CONbits_t CCP8CONbits;

#define _CCP8M0                 0x01
#define _CCP8M1                 0x02
#define _CCP8M2                 0x04
#define _CCP8M3                 0x08
#define _DC8B0                  0x10
#define _DC8B1                  0x20

//==============================================================================

extern __at(0x061A) __sfr CCPR9;
extern __at(0x061A) __sfr CCPR9L;
extern __at(0x061B) __sfr CCPR9H;

//==============================================================================
//        CCP9CON Bits

extern __at(0x061C) __sfr CCP9CON;

typedef union
  {
  struct
    {
    unsigned CCP9M0             : 1;
    unsigned CCP9M1             : 1;
    unsigned CCP9M2             : 1;
    unsigned CCP9M3             : 1;
    unsigned DC9B0              : 1;
    unsigned DC9B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP9M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC9B               : 2;
    unsigned                    : 2;
    };
  } __CCP9CONbits_t;

extern __at(0x061C) volatile __CCP9CONbits_t CCP9CONbits;

#define _CCP9M0                 0x01
#define _CCP9M1                 0x02
#define _CCP9M2                 0x04
#define _CCP9M3                 0x08
#define _DC9B0                  0x10
#define _DC9B1                  0x20

//==============================================================================

extern __at(0x061D) __sfr CCPR10;
extern __at(0x061D) __sfr CCPR10L;
extern __at(0x061E) __sfr CCPR10H;

//==============================================================================
//        CCP10CON Bits

extern __at(0x061F) __sfr CCP10CON;

typedef union
  {
  struct
    {
    unsigned CCP10M0            : 1;
    unsigned CCP10M1            : 1;
    unsigned CCP10M2            : 1;
    unsigned CCP10M3            : 1;
    unsigned DC10B0             : 1;
    unsigned DC10B1             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP10M             : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC10B              : 2;
    unsigned                    : 2;
    };
  } __CCP10CONbits_t;

extern __at(0x061F) volatile __CCP10CONbits_t CCP10CONbits;

#define _CCP10M0                0x01
#define _CCP10M1                0x02
#define _CCP10M2                0x04
#define _CCP10M3                0x08
#define _DC10B0                 0x10
#define _DC10B1                 0x20

//==============================================================================


//==============================================================================
//        STATUS_SHAD Bits

extern __at(0x0FE4) __sfr STATUS_SHAD;

typedef struct
  {
  unsigned C_SHAD               : 1;
  unsigned DC_SHAD              : 1;
  unsigned Z_SHAD               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUS_SHADbits_t;

extern __at(0x0FE4) volatile __STATUS_SHADbits_t STATUS_SHADbits;

#define _C_SHAD                 0x01
#define _DC_SHAD                0x02
#define _Z_SHAD                 0x04

//==============================================================================

extern __at(0x0FE5) __sfr WREG_SHAD;
extern __at(0x0FE6) __sfr BSR_SHAD;
extern __at(0x0FE7) __sfr PCLATH_SHAD;
extern __at(0x0FE8) __sfr FSR0L_SHAD;
extern __at(0x0FE9) __sfr FSR0H_SHAD;
extern __at(0x0FEA) __sfr FSR1L_SHAD;
extern __at(0x0FEB) __sfr FSR1H_SHAD;
extern __at(0x0FED) __sfr STKPTR;
extern __at(0x0FEE) __sfr TOSL;
extern __at(0x0FEF) __sfr TOSH;

//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define _CONFIG1                0x8007
#define _CONFIG2                0x8008

//----------------------------- CONFIG1 Options -------------------------------

#define _FOSC_LP                0xFFF8  // LP Oscillator, Low-power crystal connected between OSC1 and OSC2 pins.
#define _FOSC_XT                0xFFF9  // XT Oscillator, Crystal/resonator connected between OSC1 and OSC2 pins.
#define _FOSC_HS                0xFFFA  // HS Oscillator, High-speed crystal/resonator connected between OSC1 and OSC2 pins.
#define _FOSC_EXTRC             0xFFFB  // EXTRC oscillator: External RC circuit connected to CLKIN pin.
#define _FOSC_INTOSC            0xFFFC  // INTOSC oscillator: I/O function on CLKIN pin.
#define _FOSC_ECL               0xFFFD  // ECL, External Clock, Low Power Mode (0-0.5 MHz): device clock supplied to CLKIN pin.
#define _FOSC_ECM               0xFFFE  // ECM, External Clock, Medium Power Mode (0.5-4 MHz): device clock supplied to CLKIN pin.
#define _FOSC_ECH               0xFFFF  // ECH, External Clock, High Power Mode (4-20 MHz): device clock supplied to CLKIN pin.
#define _WDTE_OFF               0xFFE7  // WDT disabled.
#define _WDTE_SWDTEN            0xFFEF  // WDT controlled by the SWDTEN bit in the WDTCON register.
#define _WDTE_NSLEEP            0xFFF7  // WDT enabled while running and disabled in Sleep.
#define _WDTE_ON                0xFFFF  // WDT enabled.
#define _PWRTE_ON               0xFFDF  // PWRT enabled.
#define _PWRTE_OFF              0xFFFF  // PWRT disabled.
#define _MCLRE_OFF              0xFFBF  // MCLR/VPP pin function is digital input.
#define _MCLRE_ON               0xFFFF  // MCLR/VPP pin function is MCLR.
#define _CP_ON                  0xFF7F  // Program memory code protection is enabled.
#define _CP_OFF                 0xFFFF  // Program memory code protection is disabled.
#define _BOREN_OFF              0xF9FF  // Brown-out Reset disabled.
#define _BOREN_SBODEN           0xFBFF  // Brown-out Reset controlled by the SBOREN bit in the BORCON register.
#define _BOREN_NSLEEP           0xFDFF  // Brown-out Reset enabled while running and disabled in Sleep.
#define _BOREN_ON               0xFFFF  // Brown-out Reset enabled.
#define _CLKOUTEN_ON            0xF7FF  // CLKOUT function is enabled on the CLKOUT pin.
#define _CLKOUTEN_OFF           0xFFFF  // CLKOUT function is disabled. I/O or oscillator function on the CLKOUT pin.
#define _IESO_OFF               0xEFFF  // Internal/External Switchover mode is disabled.
#define _IESO_ON                0xFFFF  // Internal/External Switchover mode is enabled.
#define _FCMEN_OFF              0xDFFF  // Fail-Safe Clock Monitor is disabled.
#define _FCMEN_ON               0xFFFF  // Fail-Safe Clock Monitor is enabled.

//----------------------------- CONFIG2 Options -------------------------------

#define _WRT_ALL                0xFFFC  // 000h to 3FFFh write protected, no addresses may be modified by PMCON control.
#define _WRT_HALF               0xFFFD  // 000h to FFFh write protected, 2000h to 3FFFh may be modified by PMCON control.
#define _WRT_BOOT               0xFFFE  // 000h to 1FFh write protected, 200h to 3FFFh may be modified by PMCON control.
#define _WRT_OFF                0xFFFF  // Write protection off.
#define _VCAPEN_ON              0xFFEF  // VCAP pin function enabled.
#define _VCAPEN_OFF             0xFFFF  // VCAP pin function disabled.
#define _STVREN_OFF             0xFDFF  // Stack Overflow or Underflow will not cause a Reset.
#define _STVREN_ON              0xFFFF  // Stack Overflow or Underflow will cause a Reset.
#define _BORV_HI                0xFBFF  // Brown-out Reset Voltage (Vbor), high trip point selected.
#define _BORV_270               0xFBFF  // Brown-out Reset Voltage (Vbor), high trip point selected.
#define _BORV_LO                0xFFFF  // Brown-out Reset Voltage (Vbor), low trip point selected.
#define _BORV_245               0xFFFF  // Brown-out Reset Voltage (Vbor), low trip point selected.
#define _LPBOR_ON               0xF7FF  // Low-Power BOR is enabled.
#define _LPBOR_OFF              0xFFFF  // Low-Power BOR is disabled.
#define _LVP_OFF                0xDFFF  // High-voltage on MCLR/VPP must be used for programming.
#define _LVP_ON                 0xFFFF  // Low-voltage programming enabled.

//==============================================================================

#define _DEVID1                 0x8006

#define _IDLOC0                 0x8000
#define _IDLOC1                 0x8001
#define _IDLOC2                 0x8002
#define _IDLOC3                 0x8003

//==============================================================================

#ifndef NO_BIT_DEFINES

#define ADON                    ADCON0bits.ADON                 // bit 0
#define GO_NOT_DONE             ADCON0bits.GO_NOT_DONE          // bit 1, shadows bit in ADCON0bits
#define ADGO                    ADCON0bits.ADGO                 // bit 1, shadows bit in ADCON0bits
#define GO                      ADCON0bits.GO                   // bit 1, shadows bit in ADCON0bits
#define CHS0                    ADCON0bits.CHS0                 // bit 2
#define CHS1                    ADCON0bits.CHS1                 // bit 3
#define CHS2                    ADCON0bits.CHS2                 // bit 4
#define CHS3                    ADCON0bits.CHS3                 // bit 5
#define CHS4                    ADCON0bits.CHS4                 // bit 6

#define ADPREF0                 ADCON1bits.ADPREF0              // bit 0
#define ADPREF1                 ADCON1bits.ADPREF1              // bit 1
#define ADCS0                   ADCON1bits.ADCS0                // bit 4
#define ADCS1                   ADCON1bits.ADCS1                // bit 5
#define ADCS2                   ADCON1bits.ADCS2                // bit 6
#define ADFM                    ADCON1bits.ADFM                 // bit 7

#define ANSA0                   ANSELAbits.ANSA0                // bit 0
#define ANSA1                   ANSELAbits.ANSA1                // bit 1
#define ANSA2                   ANSELAbits.ANSA2                // bit 2
#define ANSA3                   ANSELAbits.ANSA3                // bit 3
#define ANSA5                   ANSELAbits.ANSA5                // bit 5

#define ANSB0                   ANSELBbits.ANSB0                // bit 0
#define ANSB1                   ANSELBbits.ANSB1                // bit 1
#define ANSB2                   ANSELBbits.ANSB2                // bit 2
#define ANSB3                   ANSELBbits.ANSB3                // bit 3
#define ANSB4                   ANSELBbits.ANSB4                // bit 4
#define ANSB5                   ANSELBbits.ANSB5                // bit 5

#define ANSD0                   ANSELDbits.ANSD0                // bit 0
#define ANSD1                   ANSELDbits.ANSD1                // bit 1
#define ANSD2                   ANSELDbits.ANSD2                // bit 2
#define ANSD3                   ANSELDbits.ANSD3                // bit 3

#define ANSE0                   ANSELEbits.ANSE0                // bit 0
#define ANSE1                   ANSELEbits.ANSE1                // bit 1
#define ANSE2                   ANSELEbits.ANSE2                // bit 2

#define ANSF0                   ANSELFbits.ANSF0                // bit 0
#define ANSF1                   ANSELFbits.ANSF1                // bit 1
#define ANSF2                   ANSELFbits.ANSF2                // bit 2
#define ANSF3                   ANSELFbits.ANSF3                // bit 3
#define ANSF4                   ANSELFbits.ANSF4                // bit 4
#define ANSF5                   ANSELFbits.ANSF5                // bit 5
#define ANSF6                   ANSELFbits.ANSF6                // bit 6
#define ANSF7                   ANSELFbits.ANSF7                // bit 7

#define ANSG1                   ANSELGbits.ANSG1                // bit 1
#define ANSG2                   ANSELGbits.ANSG2                // bit 2
#define ANSG3                   ANSELGbits.ANSG3                // bit 3
#define ANSG4                   ANSELGbits.ANSG4                // bit 4

#define CCP2SEL                 APFCONbits.CCP2SEL              // bit 0
#define T3CKISEL                APFCONbits.T3CKISEL             // bit 1

#define ABDEN                   BAUD1CONbits.ABDEN              // bit 0
#define WUE                     BAUD1CONbits.WUE                // bit 1
#define BRG16                   BAUD1CONbits.BRG16              // bit 3
#define SCKP                    BAUD1CONbits.SCKP               // bit 4
#define RCIDL                   BAUD1CONbits.RCIDL              // bit 6
#define ABDOVF                  BAUD1CONbits.ABDOVF             // bit 7

#define BORRDY                  BORCONbits.BORRDY               // bit 0
#define BORFS                   BORCONbits.BORFS                // bit 6
#define SBOREN                  BORCONbits.SBOREN               // bit 7

#define BSR0                    BSRbits.BSR0                    // bit 0
#define BSR1                    BSRbits.BSR1                    // bit 1
#define BSR2                    BSRbits.BSR2                    // bit 2
#define BSR3                    BSRbits.BSR3                    // bit 3
#define BSR4                    BSRbits.BSR4                    // bit 4

#define CCP1M0                  CCP1CONbits.CCP1M0              // bit 0
#define CCP1M1                  CCP1CONbits.CCP1M1              // bit 1
#define CCP1M2                  CCP1CONbits.CCP1M2              // bit 2
#define CCP1M3                  CCP1CONbits.CCP1M3              // bit 3
#define DC1B0                   CCP1CONbits.DC1B0               // bit 4
#define DC1B1                   CCP1CONbits.DC1B1               // bit 5

#define CCP2M0                  CCP2CONbits.CCP2M0              // bit 0
#define CCP2M1                  CCP2CONbits.CCP2M1              // bit 1
#define CCP2M2                  CCP2CONbits.CCP2M2              // bit 2
#define CCP2M3                  CCP2CONbits.CCP2M3              // bit 3
#define DC2B0                   CCP2CONbits.DC2B0               // bit 4
#define DC2B1                   CCP2CONbits.DC2B1               // bit 5

#define CCP3M0                  CCP3CONbits.CCP3M0              // bit 0
#define CCP3M1                  CCP3CONbits.CCP3M1              // bit 1
#define CCP3M2                  CCP3CONbits.CCP3M2              // bit 2
#define CCP3M3                  CCP3CONbits.CCP3M3              // bit 3
#define DC3B0                   CCP3CONbits.DC3B0               // bit 4
#define DC3B1                   CCP3CONbits.DC3B1               // bit 5

#define CCP4M0                  CCP4CONbits.CCP4M0              // bit 0
#define CCP4M1                  CCP4CONbits.CCP4M1              // bit 1
#define CCP4M2                  CCP4CONbits.CCP4M2              // bit 2
#define CCP4M3                  CCP4CONbits.CCP4M3              // bit 3
#define DC4B0                   CCP4CONbits.DC4B0               // bit 4
#define DC4B1                   CCP4CONbits.DC4B1               // bit 5

#define CCP5M0                  CCP5CONbits.CCP5M0              // bit 0
#define CCP5M1                  CCP5CONbits.CCP5M1              // bit 1
#define CCP5M2                  CCP5CONbits.CCP5M2              // bit 2
#define CCP5M3                  CCP5CONbits.CCP5M3              // bit 3
#define DC5B0                   CCP5CONbits.DC5B0               // bit 4
#define DC5B1                   CCP5CONbits.DC5B1               // bit 5

#define CCP6M0                  CCP6CONbits.CCP6M0              // bit 0
#define CCP6M1                  CCP6CONbits.CCP6M1              // bit 1
#define CCP6M2                  CCP6CONbits.CCP6M2              // bit 2
#define CCP6M3                  CCP6CONbits.CCP6M3              // bit 3
#define DC6B0                   CCP6CONbits.DC6B0               // bit 4
#define DC6B1                   CCP6CONbits.DC6B1               // bit 5

#define CCP7M0                  CCP7CONbits.CCP7M0              // bit 0
#define CCP7M1                  CCP7CONbits.CCP7M1              // bit 1
#define CCP7M2                  CCP7CONbits.CCP7M2              // bit 2
#define CCP7M3                  CCP7CONbits.CCP7M3              // bit 3
#define DC7B0                   CCP7CONbits.DC7B0               // bit 4
#define DC7B1                   CCP7CONbits.DC7B1               // bit 5

#define CCP8M0                  CCP8CONbits.CCP8M0              // bit 0
#define CCP8M1                  CCP8CONbits.CCP8M1              // bit 1
#define CCP8M2                  CCP8CONbits.CCP8M2              // bit 2
#define CCP8M3                  CCP8CONbits.CCP8M3              // bit 3
#define DC8B0                   CCP8CONbits.DC8B0               // bit 4
#define DC8B1                   CCP8CONbits.DC8B1               // bit 5

#define CCP9M0                  CCP9CONbits.CCP9M0              // bit 0
#define CCP9M1                  CCP9CONbits.CCP9M1              // bit 1
#define CCP9M2                  CCP9CONbits.CCP9M2              // bit 2
#define CCP9M3                  CCP9CONbits.CCP9M3              // bit 3
#define DC9B0                   CCP9CONbits.DC9B0               // bit 4
#define DC9B1                   CCP9CONbits.DC9B1               // bit 5

#define CCP10M0                 CCP10CONbits.CCP10M0            // bit 0
#define CCP10M1                 CCP10CONbits.CCP10M1            // bit 1
#define CCP10M2                 CCP10CONbits.CCP10M2            // bit 2
#define CCP10M3                 CCP10CONbits.CCP10M3            // bit 3
#define DC10B0                  CCP10CONbits.DC10B0             // bit 4
#define DC10B1                  CCP10CONbits.DC10B1             // bit 5

#define C1TSEL0                 CCPTMRS0bits.C1TSEL0            // bit 0
#define C1TSEL1                 CCPTMRS0bits.C1TSEL1            // bit 1
#define C2TSEL0                 CCPTMRS0bits.C2TSEL0            // bit 2
#define C2TSEL1                 CCPTMRS0bits.C2TSEL1            // bit 3
#define C3TSEL0                 CCPTMRS0bits.C3TSEL0            // bit 4
#define C3TSEL1                 CCPTMRS0bits.C3TSEL1            // bit 5
#define C4TSEL0                 CCPTMRS0bits.C4TSEL0            // bit 6
#define C4TSEL1                 CCPTMRS0bits.C4TSEL1            // bit 7

#define C5TSEL0                 CCPTMRS1bits.C5TSEL0            // bit 0
#define C5TSEL1                 CCPTMRS1bits.C5TSEL1            // bit 1
#define C6TSEL0                 CCPTMRS1bits.C6TSEL0            // bit 2
#define C6TSEL1                 CCPTMRS1bits.C6TSEL1            // bit 3
#define C7TSEL0                 CCPTMRS1bits.C7TSEL0            // bit 4
#define C7TSEL1                 CCPTMRS1bits.C7TSEL1            // bit 5
#define C8TSEL0                 CCPTMRS1bits.C8TSEL0            // bit 6
#define C8TSEL1                 CCPTMRS1bits.C8TSEL1            // bit 7

#define C9TSEL0                 CCPTMRS2bits.C9TSEL0            // bit 0
#define C9TSEL1                 CCPTMRS2bits.C9TSEL1            // bit 1
#define C10TSEL0                CCPTMRS2bits.C10TSEL0           // bit 2
#define C10TSEL1                CCPTMRS2bits.C10TSEL1           // bit 3

#define ADFVR0                  FVRCONbits.ADFVR0               // bit 0
#define ADFVR1                  FVRCONbits.ADFVR1               // bit 1
#define TSRNG                   FVRCONbits.TSRNG                // bit 4
#define TSEN                    FVRCONbits.TSEN                 // bit 5
#define FVRRDY                  FVRCONbits.FVRRDY               // bit 6
#define FVREN                   FVRCONbits.FVREN                // bit 7

#define IOCIF                   INTCONbits.IOCIF                // bit 0
#define INTF                    INTCONbits.INTF                 // bit 1
#define TMR0IF                  INTCONbits.TMR0IF               // bit 2, shadows bit in INTCONbits
#define T0IF                    INTCONbits.T0IF                 // bit 2, shadows bit in INTCONbits
#define IOCIE                   INTCONbits.IOCIE                // bit 3
#define INTE                    INTCONbits.INTE                 // bit 4
#define TMR0IE                  INTCONbits.TMR0IE               // bit 5, shadows bit in INTCONbits
#define T0IE                    INTCONbits.T0IE                 // bit 5, shadows bit in INTCONbits
#define PEIE                    INTCONbits.PEIE                 // bit 6
#define GIE                     INTCONbits.GIE                  // bit 7

#define IOCBF0                  IOCBFbits.IOCBF0                // bit 0
#define IOCBF1                  IOCBFbits.IOCBF1                // bit 1
#define IOCBF2                  IOCBFbits.IOCBF2                // bit 2
#define IOCBF3                  IOCBFbits.IOCBF3                // bit 3
#define IOCBF4                  IOCBFbits.IOCBF4                // bit 4
#define IOCBF5                  IOCBFbits.IOCBF5                // bit 5
#define IOCBF6                  IOCBFbits.IOCBF6                // bit 6
#define IOCBF7                  IOCBFbits.IOCBF7                // bit 7

#define IOCBN0                  IOCBNbits.IOCBN0                // bit 0
#define IOCBN1                  IOCBNbits.IOCBN1                // bit 1
#define IOCBN2                  IOCBNbits.IOCBN2                // bit 2
#define IOCBN3                  IOCBNbits.IOCBN3                // bit 3
#define IOCBN4                  IOCBNbits.IOCBN4                // bit 4
#define IOCBN5                  IOCBNbits.IOCBN5                // bit 5
#define IOCBN6                  IOCBNbits.IOCBN6                // bit 6
#define IOCBN7                  IOCBNbits.IOCBN7                // bit 7

#define IOCBP0                  IOCBPbits.IOCBP0                // bit 0
#define IOCBP1                  IOCBPbits.IOCBP1                // bit 1
#define IOCBP2                  IOCBPbits.IOCBP2                // bit 2
#define IOCBP3                  IOCBPbits.IOCBP3                // bit 3
#define IOCBP4                  IOCBPbits.IOCBP4                // bit 4
#define IOCBP5                  IOCBPbits.IOCBP5                // bit 5
#define IOCBP6                  IOCBPbits.IOCBP6                // bit 6
#define IOCBP7                  IOCBPbits.IOCBP7                // bit 7

#define LATA0                   LATAbits.LATA0                  // bit 0
#define LATA1                   LATAbits.LATA1                  // bit 1
#define LATA2                   LATAbits.LATA2                  // bit 2
#define LATA3                   LATAbits.LATA3                  // bit 3
#define LATA4                   LATAbits.LATA4                  // bit 4
#define LATA5                   LATAbits.LATA5                  // bit 5
#define LATA6                   LATAbits.LATA6                  // bit 6
#define LATA7                   LATAbits.LATA7                  // bit 7

#define LATB0                   LATBbits.LATB0                  // bit 0
#define LATB1                   LATBbits.LATB1                  // bit 1
#define LATB2                   LATBbits.LATB2                  // bit 2
#define LATB3                   LATBbits.LATB3                  // bit 3
#define LATB4                   LATBbits.LATB4                  // bit 4
#define LATB5                   LATBbits.LATB5                  // bit 5
#define LATB6                   LATBbits.LATB6                  // bit 6
#define LATB7                   LATBbits.LATB7                  // bit 7

#define LATC0                   LATCbits.LATC0                  // bit 0
#define LATC1                   LATCbits.LATC1                  // bit 1
#define LATC2                   LATCbits.LATC2                  // bit 2
#define LATC3                   LATCbits.LATC3                  // bit 3
#define LATC4                   LATCbits.LATC4                  // bit 4
#define LATC5                   LATCbits.LATC5                  // bit 5
#define LATC6                   LATCbits.LATC6                  // bit 6
#define LATC7                   LATCbits.LATC7                  // bit 7

#define LATD0                   LATDbits.LATD0                  // bit 0
#define LATD1                   LATDbits.LATD1                  // bit 1
#define LATD2                   LATDbits.LATD2                  // bit 2
#define LATD3                   LATDbits.LATD3                  // bit 3
#define LATD4                   LATDbits.LATD4                  // bit 4
#define LATD5                   LATDbits.LATD5                  // bit 5
#define LATD6                   LATDbits.LATD6                  // bit 6
#define LATD7                   LATDbits.LATD7                  // bit 7

#define LATE0                   LATEbits.LATE0                  // bit 0
#define LATE1                   LATEbits.LATE1                  // bit 1
#define LATE2                   LATEbits.LATE2                  // bit 2
#define LATE3                   LATEbits.LATE3                  // bit 3
#define LATE4                   LATEbits.LATE4                  // bit 4
#define LATE5                   LATEbits.LATE5                  // bit 5
#define LATE6                   LATEbits.LATE6                  // bit 6
#define LATE7                   LATEbits.LATE7                  // bit 7

#define LATF0                   LATFbits.LATF0                  // bit 0
#define LATF1                   LATFbits.LATF1                  // bit 1
#define LATF2                   LATFbits.LATF2                  // bit 2
#define LATF3                   LATFbits.LATF3                  // bit 3
#define LATF4                   LATFbits.LATF4                  // bit 4
#define LATF5                   LATFbits.LATF5                  // bit 5
#define LATF6                   LATFbits.LATF6                  // bit 6
#define LATF7                   LATFbits.LATF7                  // bit 7

#define LATG0                   LATGbits.LATG0                  // bit 0
#define LATG1                   LATGbits.LATG1                  // bit 1
#define LATG2                   LATGbits.LATG2                  // bit 2
#define LATG3                   LATGbits.LATG3                  // bit 3
#define LATG4                   LATGbits.LATG4                  // bit 4

#define PS0                     OPTION_REGbits.PS0              // bit 0
#define PS1                     OPTION_REGbits.PS1              // bit 1
#define PS2                     OPTION_REGbits.PS2              // bit 2
#define PSA                     OPTION_REGbits.PSA              // bit 3
#define TMR0SE                  OPTION_REGbits.TMR0SE           // bit 4, shadows bit in OPTION_REGbits
#define T0SE                    OPTION_REGbits.T0SE             // bit 4, shadows bit in OPTION_REGbits
#define TMR0CS                  OPTION_REGbits.TMR0CS           // bit 5, shadows bit in OPTION_REGbits
#define T0CS                    OPTION_REGbits.T0CS             // bit 5, shadows bit in OPTION_REGbits
#define INTEDG                  OPTION_REGbits.INTEDG           // bit 6
#define NOT_WPUEN               OPTION_REGbits.NOT_WPUEN        // bit 7

#define SCS0                    OSCCONbits.SCS0                 // bit 0
#define SCS1                    OSCCONbits.SCS1                 // bit 1
#define IRCF0                   OSCCONbits.IRCF0                // bit 3
#define IRCF1                   OSCCONbits.IRCF1                // bit 4
#define IRCF2                   OSCCONbits.IRCF2                // bit 5
#define IRCF3                   OSCCONbits.IRCF3                // bit 6

#define HFIOFS                  OSCSTATbits.HFIOFS              // bit 0
#define LFIOFR                  OSCSTATbits.LFIOFR              // bit 1
#define HFIOFR                  OSCSTATbits.HFIOFR              // bit 4
#define OSTS                    OSCSTATbits.OSTS                // bit 5
#define SOSCR                   OSCSTATbits.SOSCR               // bit 7, shadows bit in OSCSTATbits
#define T1OSCR                  OSCSTATbits.T1OSCR              // bit 7, shadows bit in OSCSTATbits

#define NOT_BOR                 PCONbits.NOT_BOR                // bit 0
#define NOT_POR                 PCONbits.NOT_POR                // bit 1
#define NOT_RI                  PCONbits.NOT_RI                 // bit 2
#define NOT_RMCLR               PCONbits.NOT_RMCLR              // bit 3
#define NOT_RWDT                PCONbits.NOT_RWDT               // bit 4
#define STKUNF                  PCONbits.STKUNF                 // bit 6
#define STKOVF                  PCONbits.STKOVF                 // bit 7

#define TMR1IE                  PIE1bits.TMR1IE                 // bit 0
#define TMR2IE                  PIE1bits.TMR2IE                 // bit 1
#define CCP1IE                  PIE1bits.CCP1IE                 // bit 2
#define SSP1IE                  PIE1bits.SSP1IE                 // bit 3, shadows bit in PIE1bits
#define SSPIE                   PIE1bits.SSPIE                  // bit 3, shadows bit in PIE1bits
#define TX1IE                   PIE1bits.TX1IE                  // bit 4, shadows bit in PIE1bits
#define TXIE                    PIE1bits.TXIE                   // bit 4, shadows bit in PIE1bits
#define RC1IE                   PIE1bits.RC1IE                  // bit 5, shadows bit in PIE1bits
#define RCIE                    PIE1bits.RCIE                   // bit 5, shadows bit in PIE1bits
#define ADIE                    PIE1bits.ADIE                   // bit 6
#define TMR1GIE                 PIE1bits.TMR1GIE                // bit 7

#define CCP2IE                  PIE2bits.CCP2IE                 // bit 0
#define TMR8IE                  PIE2bits.TMR8IE                 // bit 1
#define TMR10IE                 PIE2bits.TMR10IE                // bit 2
#define BCL1IE                  PIE2bits.BCL1IE                 // bit 3, shadows bit in PIE2bits
#define BCLIE                   PIE2bits.BCLIE                  // bit 3, shadows bit in PIE2bits
#define TMR3GIE                 PIE2bits.TMR3GIE                // bit 5
#define TMR5GIE                 PIE2bits.TMR5GIE                // bit 6
#define OSFIE                   PIE2bits.OSFIE                  // bit 7

#define TMR3IE                  PIE3bits.TMR3IE                 // bit 0
#define TMR4IE                  PIE3bits.TMR4IE                 // bit 1
#define TMR5IE                  PIE3bits.TMR5IE                 // bit 2
#define TMR6IE                  PIE3bits.TMR6IE                 // bit 3
#define CCP3IE                  PIE3bits.CCP3IE                 // bit 4
#define CCP4IE                  PIE3bits.CCP4IE                 // bit 5
#define CCP5IE                  PIE3bits.CCP5IE                 // bit 6
#define CCP6IE                  PIE3bits.CCP6IE                 // bit 7

#define SSP2IE                  PIE4bits.SSP2IE                 // bit 0
#define BCL2IE                  PIE4bits.BCL2IE                 // bit 1
#define CCP7IE                  PIE4bits.CCP7IE                 // bit 2
#define CCP8IE                  PIE4bits.CCP8IE                 // bit 3
#define TX2IE                   PIE4bits.TX2IE                  // bit 4
#define RC2IE                   PIE4bits.RC2IE                  // bit 5
#define CCP9IE                  PIE4bits.CCP9IE                 // bit 6
#define CCP10IE                 PIE4bits.CCP10IE                // bit 7

#define TMR1IF                  PIR1bits.TMR1IF                 // bit 0
#define TMR2IF                  PIR1bits.TMR2IF                 // bit 1
#define CCP1IF                  PIR1bits.CCP1IF                 // bit 2
#define SSP1IF                  PIR1bits.SSP1IF                 // bit 3, shadows bit in PIR1bits
#define SSPIF                   PIR1bits.SSPIF                  // bit 3, shadows bit in PIR1bits
#define TX1IF                   PIR1bits.TX1IF                  // bit 4, shadows bit in PIR1bits
#define TXIF                    PIR1bits.TXIF                   // bit 4, shadows bit in PIR1bits
#define RC1IF                   PIR1bits.RC1IF                  // bit 5, shadows bit in PIR1bits
#define RCIF                    PIR1bits.RCIF                   // bit 5, shadows bit in PIR1bits
#define ADIF                    PIR1bits.ADIF                   // bit 6
#define TMR1GIF                 PIR1bits.TMR1GIF                // bit 7

#define CCP2IF                  PIR2bits.CCP2IF                 // bit 0
#define TMR8IF                  PIR2bits.TMR8IF                 // bit 1
#define TMR10IF                 PIR2bits.TMR10IF                // bit 2
#define BCL1IF                  PIR2bits.BCL1IF                 // bit 3, shadows bit in PIR2bits
#define BCLIF                   PIR2bits.BCLIF                  // bit 3, shadows bit in PIR2bits
#define TMR3GIF                 PIR2bits.TMR3GIF                // bit 5
#define TMR5GIF                 PIR2bits.TMR5GIF                // bit 6
#define OSFIF                   PIR2bits.OSFIF                  // bit 7

#define TMR3IF                  PIR3bits.TMR3IF                 // bit 0
#define TMR4IF                  PIR3bits.TMR4IF                 // bit 1
#define TMR5IF                  PIR3bits.TMR5IF                 // bit 2
#define TMR6IF                  PIR3bits.TMR6IF                 // bit 3
#define CCP3IF                  PIR3bits.CCP3IF                 // bit 4
#define CCP4IF                  PIR3bits.CCP4IF                 // bit 5
#define CCP5IF                  PIR3bits.CCP5IF                 // bit 6
#define CCP6IF                  PIR3bits.CCP6IF                 // bit 7

#define SSP2IF                  PIR4bits.SSP2IF                 // bit 0
#define BCL2IF                  PIR4bits.BCL2IF                 // bit 1
#define CCP7IF                  PIR4bits.CCP7IF                 // bit 2
#define CCP8IF                  PIR4bits.CCP8IF                 // bit 3
#define TX2IF                   PIR4bits.TX2IF                  // bit 4
#define RC2IF                   PIR4bits.RC2IF                  // bit 5
#define CCP9IF                  PIR4bits.CCP9IF                 // bit 6
#define CCP10IF                 PIR4bits.CCP10IF                // bit 7

#define RD                      PMCON1bits.RD                   // bit 0
#define WR                      PMCON1bits.WR                   // bit 1
#define WREN                    PMCON1bits.WREN                 // bit 2
#define WRERR                   PMCON1bits.WRERR                // bit 3
#define FREE                    PMCON1bits.FREE                 // bit 4
#define LWLO                    PMCON1bits.LWLO                 // bit 5
#define CFGS                    PMCON1bits.CFGS                 // bit 6

#define RA0                     PORTAbits.RA0                   // bit 0
#define RA1                     PORTAbits.RA1                   // bit 1
#define RA2                     PORTAbits.RA2                   // bit 2
#define RA3                     PORTAbits.RA3                   // bit 3
#define RA4                     PORTAbits.RA4                   // bit 4
#define RA5                     PORTAbits.RA5                   // bit 5
#define RA6                     PORTAbits.RA6                   // bit 6
#define RA7                     PORTAbits.RA7                   // bit 7

#define RB0                     PORTBbits.RB0                   // bit 0
#define RB1                     PORTBbits.RB1                   // bit 1
#define RB2                     PORTBbits.RB2                   // bit 2
#define RB3                     PORTBbits.RB3                   // bit 3
#define RB4                     PORTBbits.RB4                   // bit 4
#define RB5                     PORTBbits.RB5                   // bit 5
#define RB6                     PORTBbits.RB6                   // bit 6
#define RB7                     PORTBbits.RB7                   // bit 7

#define RC0                     PORTCbits.RC0                   // bit 0
#define RC1                     PORTCbits.RC1                   // bit 1
#define RC2                     PORTCbits.RC2                   // bit 2
#define RC3                     PORTCbits.RC3                   // bit 3
#define RC4                     PORTCbits.RC4                   // bit 4
#define RC5                     PORTCbits.RC5                   // bit 5
#define RC6                     PORTCbits.RC6                   // bit 6
#define RC7                     PORTCbits.RC7                   // bit 7

#define RD0                     PORTDbits.RD0                   // bit 0
#define RD1                     PORTDbits.RD1                   // bit 1
#define RD2                     PORTDbits.RD2                   // bit 2
#define RD3                     PORTDbits.RD3                   // bit 3
#define RD4                     PORTDbits.RD4                   // bit 4
#define RD5                     PORTDbits.RD5                   // bit 5
#define RD6                     PORTDbits.RD6                   // bit 6
#define RD7                     PORTDbits.RD7                   // bit 7

#define RE0                     PORTEbits.RE0                   // bit 0
#define RE1                     PORTEbits.RE1                   // bit 1
#define RE2                     PORTEbits.RE2                   // bit 2
#define RE3                     PORTEbits.RE3                   // bit 3
#define RE4                     PORTEbits.RE4                   // bit 4
#define RE5                     PORTEbits.RE5                   // bit 5
#define RE6                     PORTEbits.RE6                   // bit 6
#define RE7                     PORTEbits.RE7                   // bit 7

#define RF0                     PORTFbits.RF0                   // bit 0
#define RF1                     PORTFbits.RF1                   // bit 1
#define RF2                     PORTFbits.RF2                   // bit 2
#define RF3                     PORTFbits.RF3                   // bit 3
#define RF4                     PORTFbits.RF4                   // bit 4
#define RF5                     PORTFbits.RF5                   // bit 5
#define RF6                     PORTFbits.RF6                   // bit 6
#define RF7                     PORTFbits.RF7                   // bit 7

#define RG0                     PORTGbits.RG0                   // bit 0
#define RG1                     PORTGbits.RG1                   // bit 1
#define RG2                     PORTGbits.RG2                   // bit 2
#define RG3                     PORTGbits.RG3                   // bit 3
#define RG4                     PORTGbits.RG4                   // bit 4
#define RG5                     PORTGbits.RG5                   // bit 5

#define RX9D                    RC1STAbits.RX9D                 // bit 0
#define OERR                    RC1STAbits.OERR                 // bit 1
#define FERR                    RC1STAbits.FERR                 // bit 2
#define ADDEN                   RC1STAbits.ADDEN                // bit 3
#define CREN                    RC1STAbits.CREN                 // bit 4
#define SREN                    RC1STAbits.SREN                 // bit 5
#define RX9                     RC1STAbits.RX9                  // bit 6
#define SPEN                    RC1STAbits.SPEN                 // bit 7

#define SSPM0                   SSP1CON1bits.SSPM0              // bit 0
#define SSPM1                   SSP1CON1bits.SSPM1              // bit 1
#define SSPM2                   SSP1CON1bits.SSPM2              // bit 2
#define SSPM3                   SSP1CON1bits.SSPM3              // bit 3
#define CKP                     SSP1CON1bits.CKP                // bit 4
#define SSPEN                   SSP1CON1bits.SSPEN              // bit 5
#define SSPOV                   SSP1CON1bits.SSPOV              // bit 6
#define WCOL                    SSP1CON1bits.WCOL               // bit 7

#define SEN                     SSP1CON2bits.SEN                // bit 0
#define RSEN                    SSP1CON2bits.RSEN               // bit 1
#define PEN                     SSP1CON2bits.PEN                // bit 2
#define RCEN                    SSP1CON2bits.RCEN               // bit 3
#define ACKEN                   SSP1CON2bits.ACKEN              // bit 4
#define ACKDT                   SSP1CON2bits.ACKDT              // bit 5
#define ACKSTAT                 SSP1CON2bits.ACKSTAT            // bit 6
#define GCEN                    SSP1CON2bits.GCEN               // bit 7

#define DHEN                    SSP1CON3bits.DHEN               // bit 0
#define AHEN                    SSP1CON3bits.AHEN               // bit 1
#define SBCDE                   SSP1CON3bits.SBCDE              // bit 2
#define SDAHT                   SSP1CON3bits.SDAHT              // bit 3
#define BOEN                    SSP1CON3bits.BOEN               // bit 4
#define SCIE                    SSP1CON3bits.SCIE               // bit 5
#define PCIE                    SSP1CON3bits.PCIE               // bit 6
#define ACKTIM                  SSP1CON3bits.ACKTIM             // bit 7

#define BF                      SSP1STATbits.BF                 // bit 0
#define UA                      SSP1STATbits.UA                 // bit 1
#define R_NOT_W                 SSP1STATbits.R_NOT_W            // bit 2
#define S                       SSP1STATbits.S                  // bit 3
#define P                       SSP1STATbits.P                  // bit 4
#define D_NOT_A                 SSP1STATbits.D_NOT_A            // bit 5
#define CKE                     SSP1STATbits.CKE                // bit 6
#define SMP                     SSP1STATbits.SMP                // bit 7

#define C                       STATUSbits.C                    // bit 0
#define DC                      STATUSbits.DC                   // bit 1
#define Z                       STATUSbits.Z                    // bit 2
#define NOT_PD                  STATUSbits.NOT_PD               // bit 3
#define NOT_TO                  STATUSbits.NOT_TO               // bit 4

#define C_SHAD                  STATUS_SHADbits.C_SHAD          // bit 0
#define DC_SHAD                 STATUS_SHADbits.DC_SHAD         // bit 1
#define Z_SHAD                  STATUS_SHADbits.Z_SHAD          // bit 2

#define TMR1ON                  T1CONbits.TMR1ON                // bit 0
#define NOT_T1SYNC              T1CONbits.NOT_T1SYNC            // bit 2
#define SOSCEN                  T1CONbits.SOSCEN                // bit 3, shadows bit in T1CONbits
#define T1OSCEN                 T1CONbits.T1OSCEN               // bit 3, shadows bit in T1CONbits
#define T1CKPS0                 T1CONbits.T1CKPS0               // bit 4
#define T1CKPS1                 T1CONbits.T1CKPS1               // bit 5
#define TMR1CS0                 T1CONbits.TMR1CS0               // bit 6
#define TMR1CS1                 T1CONbits.TMR1CS1               // bit 7

#define T1GSS0                  T1GCONbits.T1GSS0               // bit 0
#define T1GSS1                  T1GCONbits.T1GSS1               // bit 1
#define T1GVAL                  T1GCONbits.T1GVAL               // bit 2
#define T1GGO_NOT_DONE          T1GCONbits.T1GGO_NOT_DONE       // bit 3
#define T1GSPM                  T1GCONbits.T1GSPM               // bit 4
#define T1GTM                   T1GCONbits.T1GTM                // bit 5
#define T1GPOL                  T1GCONbits.T1GPOL               // bit 6
#define TMR1GE                  T1GCONbits.TMR1GE               // bit 7

#define T2CKPS0                 T2CONbits.T2CKPS0               // bit 0
#define T2CKPS1                 T2CONbits.T2CKPS1               // bit 1
#define TMR2ON                  T2CONbits.TMR2ON                // bit 2
#define T2OUTPS0                T2CONbits.T2OUTPS0              // bit 3
#define T2OUTPS1                T2CONbits.T2OUTPS1              // bit 4
#define T2OUTPS2                T2CONbits.T2OUTPS2              // bit 5
#define T2OUTPS3                T2CONbits.T2OUTPS3              // bit 6

#define T3GSS0                  T3GCONbits.T3GSS0               // bit 0
#define T3GSS1                  T3GCONbits.T3GSS1               // bit 1
#define T3GVAL                  T3GCONbits.T3GVAL               // bit 2
#define T3GGO_NOT_DONE          T3GCONbits.T3GGO_NOT_DONE       // bit 3
#define T3GSPM                  T3GCONbits.T3GSPM               // bit 4
#define T3GTM                   T3GCONbits.T3GTM                // bit 5
#define T3GPOL                  T3GCONbits.T3GPOL               // bit 6
#define TMR3GE                  T3GCONbits.TMR3GE               // bit 7

#define T4CKPS0                 T4CONbits.T4CKPS0               // bit 0
#define T4CKPS1                 T4CONbits.T4CKPS1               // bit 1
#define TMR4ON                  T4CONbits.TMR4ON                // bit 2
#define T4OUTPS0                T4CONbits.T4OUTPS0              // bit 3
#define T4OUTPS1                T4CONbits.T4OUTPS1              // bit 4
#define T4OUTPS2                T4CONbits.T4OUTPS2              // bit 5
#define T4OUTPS3                T4CONbits.T4OUTPS3              // bit 6

#define T5GSS0                  T5GCONbits.T5GSS0               // bit 0
#define T5GSS1                  T5GCONbits.T5GSS1               // bit 1
#define T5GVAL                  T5GCONbits.T5GVAL               // bit 2
#define T5GGO_NOT_DONE          T5GCONbits.T5GGO_NOT_DONE       // bit 3
#define T5GSPM                  T5GCONbits.T5GSPM               // bit 4
#define T5GTM                   T5GCONbits.T5GTM                // bit 5
#define T5GPOL                  T5GCONbits.T5GPOL               // bit 6
#define TMR5GE                  T5GCONbits.TMR5GE               // bit 7

#define T6CKPS0                 T6CONbits.T6CKPS0               // bit 0
#define T6CKPS1                 T6CONbits.T6CKPS1               // bit 1
#define TMR6ON                  T6CONbits.TMR6ON                // bit 2
#define T6OUTPS0                T6CONbits.T6OUTPS0              // bit 3
#define T6OUTPS1                T6CONbits.T6OUTPS1              // bit 4
#define T6OUTPS2                T6CONbits.T6OUTPS2              // bit 5
#define T6OUTPS3                T6CONbits.T6OUTPS3              // bit 6

#define T8CKPS0                 T8CONbits.T8CKPS0               // bit 0
#define T8CKPS1                 T8CONbits.T8CKPS1               // bit 1
#define TMR8ON                  T8CONbits.TMR8ON                // bit 2
#define T8OUTPS0                T8CONbits.T8OUTPS0              // bit 3
#define T8OUTPS1                T8CONbits.T8OUTPS1              // bit 4
#define T8OUTPS2                T8CONbits.T8OUTPS2              // bit 5
#define T8OUTPS3                T8CONbits.T8OUTPS3              // bit 6

#define T10CKPS0                T10CONbits.T10CKPS0             // bit 0
#define T10CKPS1                T10CONbits.T10CKPS1             // bit 1
#define TMR10ON                 T10CONbits.TMR10ON              // bit 2
#define T10OUTPS0               T10CONbits.T10OUTPS0            // bit 3
#define T10OUTPS1               T10CONbits.T10OUTPS1            // bit 4
#define T10OUTPS2               T10CONbits.T10OUTPS2            // bit 5
#define T10OUTPS3               T10CONbits.T10OUTPS3            // bit 6

#define TRISA0                  TRISAbits.TRISA0                // bit 0
#define TRISA1                  TRISAbits.TRISA1                // bit 1
#define TRISA2                  TRISAbits.TRISA2                // bit 2
#define TRISA3                  TRISAbits.TRISA3                // bit 3
#define TRISA4                  TRISAbits.TRISA4                // bit 4
#define TRISA5                  TRISAbits.TRISA5                // bit 5
#define TRISA6                  TRISAbits.TRISA6                // bit 6
#define TRISA7                  TRISAbits.TRISA7                // bit 7

#define TRISB0                  TRISBbits.TRISB0                // bit 0
#define TRISB1                  TRISBbits.TRISB1                // bit 1
#define TRISB2                  TRISBbits.TRISB2                // bit 2
#define TRISB3                  TRISBbits.TRISB3                // bit 3
#define TRISB4                  TRISBbits.TRISB4                // bit 4
#define TRISB5                  TRISBbits.TRISB5                // bit 5
#define TRISB6                  TRISBbits.TRISB6                // bit 6
#define TRISB7                  TRISBbits.TRISB7                // bit 7

#define TRISC0                  TRISCbits.TRISC0                // bit 0
#define TRISC1                  TRISCbits.TRISC1                // bit 1
#define TRISC2                  TRISCbits.TRISC2                // bit 2
#define TRISC3                  TRISCbits.TRISC3                // bit 3
#define TRISC4                  TRISCbits.TRISC4                // bit 4
#define TRISC5                  TRISCbits.TRISC5                // bit 5
#define TRISC6                  TRISCbits.TRISC6                // bit 6
#define TRISC7                  TRISCbits.TRISC7                // bit 7

#define TRISD0                  TRISDbits.TRISD0                // bit 0
#define TRISD1                  TRISDbits.TRISD1                // bit 1
#define TRISD2                  TRISDbits.TRISD2                // bit 2
#define TRISD3                  TRISDbits.TRISD3                // bit 3
#define TRISD4                  TRISDbits.TRISD4                // bit 4
#define TRISD5                  TRISDbits.TRISD5                // bit 5
#define TRISD6                  TRISDbits.TRISD6                // bit 6
#define TRISD7                  TRISDbits.TRISD7                // bit 7

#define TRISE0                  TRISEbits.TRISE0                // bit 0
#define TRISE1                  TRISEbits.TRISE1                // bit 1
#define TRISE2                  TRISEbits.TRISE2                // bit 2
#define TRISE3                  TRISEbits.TRISE3                // bit 3
#define TRISE4                  TRISEbits.TRISE4                // bit 4
#define TRISE5                  TRISEbits.TRISE5                // bit 5
#define TRISE6                  TRISEbits.TRISE6                // bit 6
#define TRISE7                  TRISEbits.TRISE7                // bit 7

#define TRISF0                  TRISFbits.TRISF0                // bit 0
#define TRISF1                  TRISFbits.TRISF1                // bit 1
#define TRISF2                  TRISFbits.TRISF2                // bit 2
#define TRISF3                  TRISFbits.TRISF3                // bit 3
#define TRISF4                  TRISFbits.TRISF4                // bit 4
#define TRISF5                  TRISFbits.TRISF5                // bit 5
#define TRISF6                  TRISFbits.TRISF6                // bit 6
#define TRISF7                  TRISFbits.TRISF7                // bit 7

#define TRISG0                  TRISGbits.TRISG0                // bit 0
#define TRISG1                  TRISGbits.TRISG1                // bit 1
#define TRISG2                  TRISGbits.TRISG2                // bit 2
#define TRISG3                  TRISGbits.TRISG3                // bit 3
#define TRISG4                  TRISGbits.TRISG4                // bit 4

#define TX9D                    TX1STAbits.TX9D                 // bit 0
#define TRMT                    TX1STAbits.TRMT                 // bit 1
#define BRGH                    TX1STAbits.BRGH                 // bit 2
#define SENDB                   TX1STAbits.SENDB                // bit 3
#define SYNC                    TX1STAbits.SYNC                 // bit 4
#define TXEN                    TX1STAbits.TXEN                 // bit 5
#define TX9                     TX1STAbits.TX9                  // bit 6
#define CSRC                    TX1STAbits.CSRC                 // bit 7

#define VREGPM                  VREGCONbits.VREGPM              // bit 1

#define SWDTEN                  WDTCONbits.SWDTEN               // bit 0
#define WDTPS0                  WDTCONbits.WDTPS0               // bit 1
#define WDTPS1                  WDTCONbits.WDTPS1               // bit 2
#define WDTPS2                  WDTCONbits.WDTPS2               // bit 3
#define WDTPS3                  WDTCONbits.WDTPS3               // bit 4
#define WDTPS4                  WDTCONbits.WDTPS4               // bit 5

#define WPUB0                   WPUBbits.WPUB0                  // bit 0
#define WPUB1                   WPUBbits.WPUB1                  // bit 1
#define WPUB2                   WPUBbits.WPUB2                  // bit 2
#define WPUB3                   WPUBbits.WPUB3                  // bit 3
#define WPUB4                   WPUBbits.WPUB4                  // bit 4
#define WPUB5                   WPUBbits.WPUB5                  // bit 5
#define WPUB6                   WPUBbits.WPUB6                  // bit 6
#define WPUB7                   WPUBbits.WPUB7                  // bit 7

#define WPUD0                   WPUDbits.WPUD0                  // bit 0
#define WPUD1                   WPUDbits.WPUD1                  // bit 1
#define WPUD2                   WPUDbits.WPUD2                  // bit 2
#define WPUD3                   WPUDbits.WPUD3                  // bit 3
#define WPUD4                   WPUDbits.WPUD4                  // bit 4
#define WPUD5                   WPUDbits.WPUD5                  // bit 5
#define WPUD6                   WPUDbits.WPUD6                  // bit 6
#define WPUD7                   WPUDbits.WPUD7                  // bit 7

#define WPUE0                   WPUEbits.WPUE0                  // bit 0
#define WPUE1                   WPUEbits.WPUE1                  // bit 1
#define WPUE2                   WPUEbits.WPUE2                  // bit 2
#define WPUE3                   WPUEbits.WPUE3                  // bit 3
#define WPUE4                   WPUEbits.WPUE4                  // bit 4
#define WPUE5                   WPUEbits.WPUE5                  // bit 5
#define WPUE6                   WPUEbits.WPUE6                  // bit 6
#define WPUE7                   WPUEbits.WPUE7                  // bit 7

#define WPUG5                   WPUGbits.WPUG5                  // bit 5

#endif // #ifndef NO_BIT_DEFINES

#endif // #ifndef __PIC16F1526_H__
